/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool;

import dragon.nlp.Sentence;
import dragon.nlp.Word;
import dragon.nlp.tool.Tagger;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import gov.nih.nlm.nls.mps.POSTagger;
import java.util.ArrayList;
import java.util.List;

public class MedPostTagger
implements Tagger {
    private POSTagger tag;

    public MedPostTagger() {
        this(EnvVariable.getDragonHome() + "/nlpdata/tagger");
    }

    public MedPostTagger(String workDir) {
        try {
            if (!FileUtil.exist(workDir) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + workDir)) {
                workDir = EnvVariable.getDragonHome() + "/" + workDir;
            }
            this.tag = new POSTagger(workDir + "/lexDB.serial", workDir + "/ngramOne.serial");
            if (this.tag == null) {
                System.out.println("Failed to create POS tagger");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void tag(Sentence sent) {
        ArrayList<String> sentenceForTagger = new ArrayList<String>();
        Word word = sent.getFirstWord();
        while (word != null) {
            sentenceForTagger.add(word.getContent());
            word = word.next;
        }
        List result2 = this.tag.tagSentence(sentenceForTagger);
        if (result2.size() <= 0) {
            return;
        }
        word = sent.getFirstWord();
        int i = 0;
        while (i < result2.size()) {
            String posLabel = (String)result2.get(i);
            word.setPOS(posLabel, this.getPOSIndex(posLabel, word));
            word = word.next;
            ++i;
        }
    }

    protected int getPOSIndex(String pos, Word word) {
        int posIndex;
        if (word.isPunctuation()) {
            pos = word.getContent();
            posIndex = 0;
        } else {
            posIndex = pos.startsWith("noun") ? 1 : (pos.startsWith("verb") ? 2 : (pos.startsWith("adj") ? 3 : (pos.startsWith("adv") ? 4 : (pos.startsWith("conj") ? 8 : (pos.startsWith("det") ? 7 : (pos.startsWith("pron") ? 6 : (pos.startsWith("prep") ? 5 : (pos.startsWith("num") ? 9 : (pos.startsWith("aux") ? 2 : (pos.startsWith("model") ? 2 : (pos.startsWith("compl") ? 7 : 0)))))))))));
        }
        if (posIndex > 0 && posIndex != 1 && word.isAllCapital()) {
            posIndex = 1;
        }
        return posIndex;
    }
}

