/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool;

import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import edu.cmu.cs.linkgrammar.Constituent;
import edu.cmu.cs.linkgrammar.Dictionary;
import edu.cmu.cs.linkgrammar.Linkage;
import edu.cmu.cs.linkgrammar.ParseOptions;
import edu.cmu.cs.linkgrammar.Sentence;

public class LinkGrammar {
    private Dictionary lgd;
    private ParseOptions lgp;
    private Sentence lgs;

    public LinkGrammar() {
        this(EnvVariable.getDragonHome() + "/nlpdata/linkgrammar", 100, 1);
    }

    public LinkGrammar(int maxLinkage, int maxParseTime) {
        this(EnvVariable.getDragonHome() + "/nlpdata/linkgrammar", maxLinkage, maxParseTime);
    }

    public LinkGrammar(String workDir, int maxLinkage, int maxParseTime) {
        if (!FileUtil.exist(workDir) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + workDir)) {
            workDir = EnvVariable.getDragonHome() + "/" + workDir;
        }
        this.lgd = new Dictionary(workDir + "/4.0.dict", "4.0.knowledge", "4.0.constituent-knowledge", "4.0.affix");
        this.lgp = new ParseOptions();
        this.lgp.parseOptionsSetShortLength(10);
        this.lgp.parseOptionsSetMaxNullCount(10);
        this.lgp.parseOptionsSetLinkageLimit(maxLinkage);
        this.lgp.parseOptionsSetMaxParseTime(maxParseTime);
    }

    public static void main(String[] args) {
        Sentence lgs;
        LinkGrammar lg = new LinkGrammar();
        String example = "";
        int i = 0;
        while (i < args.length) {
            example = example + " " + args[i];
            ++i;
        }
        if (example.length() == 0) {
            example = "I love you";
        }
        if ((lgs = lg.parse(example)).sentenceNumLinkagesFound() < 1) {
            lgs.sentenceDelete();
            System.out.println("No linkage was found.");
        } else {
            Linkage link = lg.getLinkage(0);
            System.out.println(link.linkagePrintDiagram());
            System.out.println(lg.getConstituentTree(link, 1));
            System.out.println(lg.getConstituentTree(link, 2));
            link.linkageDelete();
            lgs.sentenceDelete();
        }
        lg.close();
    }

    public Sentence parse(String sent) {
        boolean resource_exhausted;
        this.lgs = new Sentence(sent, this.lgd);
        this.lgs.parse(this.lgp);
        boolean bl = resource_exhausted = this.lgp.parseOptionsResourcesExhausted() > 0;
        if (resource_exhausted) {
            this.lgp.parseOptionsResetResources();
        }
        return this.lgs;
    }

    public Linkage getLinkage(int index) {
        return new Linkage(index, this.lgs, this.lgp);
    }

    public String getConstituentTree(Linkage linkage, int mode) {
        Constituent lgc = new Constituent(linkage);
        String tree = lgc.printConstituentTree(linkage, mode);
        lgc.linkageFreeConstituentTree();
        return tree;
    }

    public void close() {
        this.lgd.dictionaryDelete();
        this.lgp.parseOptionsDelete();
    }
}

