/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.matrix.DoubleFlatSparseMatrix;
import dragon.nlp.ontology.umls.UmlsSTY;
import dragon.nlp.ontology.umls.UmlsSTYList;
import dragon.util.DBUtil;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.ResultSet;

public class UmlsRelationNet {
    protected DoubleFlatSparseMatrix matrix;
    protected UmlsSTYList list;

    public UmlsRelationNet(String relationFile, UmlsSTYList list2) {
        this.list = list2;
        this.loadRelations(relationFile);
    }

    public UmlsRelationNet(Connection con, UmlsSTYList list2) {
        this.list = list2;
        this.loadRelations(con);
    }

    /*
     * WARNING - void declaration
     */
    private boolean loadRelations(String filename) {
        try {
            String line;
            BufferedReader br = FileUtil.getTextReader(filename);
            this.matrix = new DoubleFlatSparseMatrix();
            while ((line = br.readLine()) != null) {
                void var3_3;
                String[] arrField = var3_3.split("\t");
                int first = this.list.lookup(arrField[0]).getIndex();
                int second = this.list.lookup(arrField[2]).getIndex();
                double relation = this.list.lookup(arrField[1]).getIndex() + 1;
                this.matrix.add(first, second, relation);
            }
            br.close();
            this.matrix.finalizeData(false);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean loadRelations(Connection con) {
        try {
            ResultSet rs = DBUtil.getResultSet(con, "select * from SRSTRE1");
            this.matrix = new DoubleFlatSparseMatrix();
            while (rs.next()) {
                int first = this.list.lookup(rs.getString(1)).getIndex();
                int second = this.list.lookup(rs.getString(3)).getIndex();
                double relation = this.list.lookup(rs.getString(2)).getIndex() + 1;
                this.matrix.add(first, second, relation);
            }
            rs.close();
            rs.getStatement().close();
            this.matrix.finalizeData(false);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String[] getRelations(String[] arrFirstST, String[] arrSecondST) {
        if (arrFirstST == null || arrSecondST == null) {
            return null;
        }
        SortedArray typeList = new SortedArray(3);
        int i = 0;
        while (i < arrFirstST.length) {
            int first = this.list.lookup(arrFirstST[i]).getIndex();
            int j = 0;
            while (j < arrSecondST.length) {
                String relation = this.getRelations(first, this.list.lookup(arrSecondST[j]).getIndex());
                if (relation != null) {
                    typeList.add(relation);
                }
                ++j;
            }
            ++i;
        }
        if (typeList.size() > 0) {
            String[] arrTypes = new String[typeList.size()];
            i = 0;
            while (i < typeList.size()) {
                arrTypes[i] = (String)typeList.get(i);
                ++i;
            }
            return arrTypes;
        }
        return null;
    }

    public String getRelations(String firstST, String secondST) {
        if (firstST == null || secondST == null) {
            return null;
        }
        return this.getRelations(this.list.lookup(firstST).getIndex(), this.list.lookup(secondST).getIndex());
    }

    public String getRelations(int firstST, int secondST) {
        int index = (int)this.matrix.get(firstST, secondST) - 1;
        if (index <= 0) {
            index = (int)this.matrix.get(secondST, firstST) - 1;
        }
        if (index > 0) {
            return ((UmlsSTY)this.list.get(index)).toString();
        }
        return null;
    }

    public boolean isSemanticRelated(String[] arrFirstST, String[] arrSecondST) {
        if (arrFirstST == null || arrSecondST == null) {
            return false;
        }
        int i = 0;
        while (i < arrFirstST.length) {
            int first = this.list.lookup(arrFirstST[i]).getIndex();
            int j = 0;
            while (j < arrSecondST.length) {
                if (this.isSemanticRelated(first, this.list.lookup(arrSecondST[j]).getIndex())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean isSemanticRelated(String firstST, String secondST) {
        if (firstST == null || secondST == null) {
            return false;
        }
        return this.isSemanticRelated(this.list.lookup(firstST).getIndex(), this.list.lookup(secondST).getIndex());
    }

    public boolean isSemanticRelated(int firstST, int secondST) {
        return this.matrix.get(firstST, secondST) > 0.0 || this.matrix.get(secondST, firstST) > 0.0;
    }
}

