/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.nlp.ontology.BasicTerm;
import dragon.nlp.ontology.BasicTermList;
import dragon.nlp.ontology.Ontology;
import dragon.nlp.ontology.SemanticNet;
import dragon.nlp.ontology.umls.UmlsCUI;
import dragon.nlp.ontology.umls.UmlsCUIList;
import dragon.nlp.ontology.umls.UmlsExactOntology;
import dragon.nlp.ontology.umls.UmlsRelationNet;
import dragon.nlp.ontology.umls.UmlsSTYList;
import dragon.nlp.ontology.umls.UmlsSemanticNet;
import dragon.nlp.tool.Lemmatiser;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import java.io.File;
import java.util.Date;

public class UmlsFileBackedOntology
extends UmlsExactOntology
implements Ontology {
    private UmlsCUIList cuiList;
    private BasicTermList termList;
    private File directory;
    private UmlsSemanticNet snNet;

    public UmlsFileBackedOntology(Lemmatiser lemmatiser) {
        this(EnvVariable.getDragonHome() + "/nlpdata/umls", lemmatiser);
    }

    public UmlsFileBackedOntology(String workDir, Lemmatiser lemmatiser) {
        super(lemmatiser);
        if (!FileUtil.exist(workDir) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + workDir)) {
            workDir = EnvVariable.getDragonHome() + "/" + workDir;
        }
        this.directory = new File(workDir);
        this.cuiList = new UmlsCUIList(this.directory + "/cui.list");
        this.termList = new BasicTermList(this.directory + "/termindex.list");
        UmlsSTYList styList = new UmlsSTYList(this.directory + "/semantictype.list");
        UmlsRelationNet relationNet = new UmlsRelationNet(this.directory + "/semanticrelation.list", styList);
        this.snNet = new UmlsSemanticNet(this, styList, relationNet);
        System.out.println(new Date() + " Ontology Loading Done!");
    }

    public SemanticNet getSemanticNet() {
        return this.snNet;
    }

    public String[] getSemanticType(String cui) {
        UmlsCUI cur = this.cuiList.lookup(cui);
        if (cur == null) {
            return null;
        }
        return cur.getAllSTY();
    }

    public String[] getCUI(String term) {
        BasicTerm cur = this.termList.lookup(term);
        if (cur == null) {
            return null;
        }
        return cur.getAllCUI();
    }

    public boolean isTerm(String term) {
        return this.termList.lookup(term) != null;
    }
}

