/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.mesh;

import dragon.nlp.ontology.mesh.MeshNode;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collections;

public class MeshNodeList
extends SortedArray {
    private static final long serialVersionUID = 1L;

    public MeshNodeList(String fileName) {
        this.loadMeshNodeList(fileName);
    }

    public MeshNode lookup(String path) {
        int pos = this.binarySearch(new MeshNode(path));
        if (pos < 0) {
            return null;
        }
        return (MeshNode)this.get(pos);
    }

    public MeshNode lookup(MeshNode node) {
        int pos = this.binarySearch(node.getPath());
        if (pos < 0) {
            return null;
        }
        return (MeshNode)this.get(pos);
    }

    private boolean loadMeshNodeList(String filename) {
        try {
            MeshNode cur;
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine();
            int total = Integer.parseInt(line);
            ArrayList<MeshNode> list2 = new ArrayList<MeshNode>(total);
            int i = 0;
            while (i < total) {
                line = br.readLine();
                String[] arrField = line.split(";");
                cur = new MeshNode(arrField[0], arrField[1]);
                list2.add(cur);
                ++i;
            }
            br.close();
            Collections.sort(list2);
            this.addAll(list2);
            i = 0;
            while (i < list2.size()) {
                cur = (MeshNode)list2.get(i);
                String path = cur.getPath();
                int startPos = path.indexOf(46);
                while (startPos >= 0) {
                    MeshNode parent = this.lookup(path.substring(0, startPos));
                    if (parent != null) {
                        parent.setDescendantNum(parent.getDescendantNum() + 1);
                    }
                    startPos = path.indexOf(46, startPos + 1);
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

