/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology;

import dragon.nlp.Word;
import dragon.nlp.ontology.Vocabulary;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collections;

public class ChineseVocabulary
implements Vocabulary {
    private SortedArray list;
    private String[] arrPhrase;

    public ChineseVocabulary(String vobFile) {
        this.load(vobFile);
    }

    public int getPhraseIndex(long phraseUID) {
        int pos = this.list.binarySearch(new ChinesePhrase(phraseUID, -1));
        if (pos < 0) {
            return -1;
        }
        return ((ChinesePhrase)this.list.get(pos)).getIndex();
    }

    public boolean isPhrase(String term) {
        return this.list.binarySearch(new ChinesePhrase(this.getUID(term), -1)) >= 0;
    }

    public boolean isPhrase(Word start, Word end) {
        return false;
    }

    public boolean isStartingWord(Word cur) {
        return true;
    }

    public Word findPhrase(Word start) {
        return null;
    }

    public int getPhraseNum() {
        return this.arrPhrase.length;
    }

    public String getPhrase(int index) {
        return this.arrPhrase[index];
    }

    public int maxPhraseLength() {
        return 4;
    }

    public int minPhraseLength() {
        return 2;
    }

    public void setAdjectivePhraseOption(boolean enabled) {
    }

    public boolean getAdjectivePhraseOption() {
        return false;
    }

    public void setNPPOption(boolean enabled) {
    }

    public boolean getNPPOption() {
        return false;
    }

    public void setCoordinateOption(boolean enabled) {
    }

    public boolean getCoordinateOption() {
        return false;
    }

    public void setLemmaOption(boolean enabled) {
    }

    public boolean getLemmaOption() {
        return false;
    }

    public long getUID(String phrase2) {
        if (phrase2 == null || phrase2.length() > 4 || phrase2.length() == 0) {
            return -1L;
        }
        long uid = phrase2.charAt(0);
        int i = 1;
        while (i < phrase2.length()) {
            uid = (uid << 16) + (long)phrase2.charAt(i);
            ++i;
        }
        return uid;
    }

    private void load(String vobFile) {
        try {
            BufferedReader br = FileUtil.getTextReader(vobFile, "GBK");
            String line = br.readLine();
            String[] arrField = line.split("\t");
            int total = Integer.parseInt(arrField[0]);
            this.arrPhrase = new String[total];
            ArrayList<ChinesePhrase> phraseList = new ArrayList<ChinesePhrase>(total);
            int i = 0;
            while (i < total) {
                line = br.readLine();
                arrField = line.split("\t");
                this.arrPhrase[i] = arrField[0];
                if (this.arrPhrase[i].length() <= 4) {
                    phraseList.add(new ChinesePhrase(this.getUID(this.arrPhrase[i]), i));
                }
                ++i;
            }
            Collections.sort(phraseList);
            this.list = new SortedArray(total);
            this.list.addAll(phraseList);
            phraseList.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ChinesePhrase
    implements Comparable {
        private long id;
        private int index;

        public ChinesePhrase(long id, int index) {
            this.id = id;
            this.index = index;
        }

        public int compareTo(Object obj) {
            long objId = ((ChinesePhrase)obj).getID();
            if (this.id > objId) {
                return 1;
            }
            if (this.id < objId) {
                return -1;
            }
            return 0;
        }

        public long getID() {
            return this.id;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

