/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Document;
import dragon.nlp.DocumentParser;
import dragon.nlp.Paragraph;
import dragon.nlp.Sentence;
import dragon.nlp.Word;
import java.util.ArrayList;

public class EngDocumentParser
implements DocumentParser {
    public static final String defParaDelimitor = "\n\n";
    public static final String defSentDelimitor = ".;?!";
    public static final String defWordDelimitor = " \r\n\t_-.;,?/\"'`:(){}!+[]><=%$#*@&^~|\\";
    public static final String punctuations = "\r\n\t_-.;,?/\"'`:(){}!+[]><=%$#*@&^~|\\";
    protected String wordDelimitor;
    protected String paraDelimitor = "\n\n";
    protected String sentDelimitor = ".;?!";

    public EngDocumentParser() {
        this(null);
    }

    public EngDocumentParser(String wordDelimitor) {
        this.wordDelimitor = wordDelimitor == null ? defWordDelimitor : wordDelimitor;
    }

    public Document parse(String doc) {
        if (doc == null || doc.length() == 0) {
            return null;
        }
        Document newDoc = new Document();
        doc = doc.replaceAll("\r\n", "\n");
        doc = doc.replace('\r', '\n');
        try {
            int start = 0;
            while (start < doc.length() - 1) {
                int end = doc.indexOf(this.paraDelimitor, start);
                if (end > 0) {
                    if (end > start) {
                        newDoc.addParagraph(this.parseParagraph(doc.substring(start, end)));
                    }
                    start = end + 2;
                    continue;
                }
                newDoc.addParagraph(this.parseParagraph(doc.substring(start)));
                start = doc.length();
            }
            return newDoc;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Paragraph parseParagraph(String paragraph) {
        int len;
        int i = 0;
        int j = 0;
        int start = 0;
        if (paragraph == null || paragraph.length() == 0) {
            return null;
        }
        Paragraph newPara = new Paragraph();
        if (this.sentDelimitor.indexOf(46) < 0) {
            this.sentDelimitor = "." + this.sentDelimitor;
        }
        paragraph = paragraph.replace('\n', ' ');
        if (this.sentDelimitor.indexOf((paragraph = paragraph.trim()).charAt((len = paragraph.length()) - 1)) < 0) {
            paragraph = paragraph + ".";
            ++len;
        }
        while (start < len) {
            String sent;
            int min2 = -1;
            j = start;
            while (min2 == -1 && j < len) {
                min2 = paragraph.indexOf(46, j);
                if (min2 >= 0) {
                    j = min2 + 1;
                    if (this.isSentencePeriod(min2, paragraph)) continue;
                    min2 = -1;
                    continue;
                }
                j = len;
            }
            i = 0;
            while (i < this.sentDelimitor.length()) {
                j = paragraph.indexOf(this.sentDelimitor.charAt(i), start);
                if (j >= 0 && this.sentDelimitor.charAt(i) != '.' && (min2 < 0 || j < min2)) {
                    min2 = j;
                }
                ++i;
            }
            if (min2 > 0) {
                sent = paragraph.substring(start, min2 + 1);
                newPara.addSentence(this.parseSentence(sent));
                start = min2 + 1;
                continue;
            }
            sent = paragraph.substring(start) + ".";
            newPara.addSentence(this.parseSentence(sent));
            start = len;
        }
        return newPara;
    }

    /*
     * Unable to fully structure code
     */
    public Sentence parseSentence(String sentence) {
        if (sentence == null || sentence.length() == 0) {
            return null;
        }
        flag = 0;
        start = 0;
        newSent = new Sentence();
        checkPeriod = this.wordDelimitor.indexOf(46) < 0;
        checkApostrophes = this.wordDelimitor.indexOf(39) < 0;
        len = (sentence = sentence.trim()).length();
        if (len <= 0) {
            return null;
        }
        if (this.sentDelimitor.indexOf(sentence.charAt(len - 1)) >= 0) {
            newSent.setPunctuation(sentence.charAt(len - 1));
        } else {
            sentence = sentence + ".";
            newSent.setPunctuation('.');
            ++len;
        }
        i = 0;
        while (i < len - 1) {
            block20: {
                block19: {
                    ch = sentence.charAt(i);
                    if (!checkPeriod || ch != '.') break block19;
                    if (this.isPeriodAsWord(i, start, sentence)) ** GOTO lbl-1000
                    if (flag >= 2) {
                        newSent.addWord(this.parseWord(sentence.substring(start, i)));
                    }
                    flag = 2;
                    start = i;
                    break block20;
                }
                if (checkApostrophes && ch == '\'' && (ret = this.isApostrophesAsWord(i, start, sentence)) < 2) {
                    if (flag >= 2) {
                        newSent.addWord(this.parseWord(sentence.substring(start, i)));
                    }
                    flag = 2;
                    start = i;
                } else if (ch == ' ') {
                    if (flag >= 2) {
                        newSent.addWord(this.parseWord(sentence.substring(start, i)));
                    }
                    flag = 1;
                } else if (this.wordDelimitor.indexOf(ch) >= 0) {
                    if (flag >= 2) {
                        newSent.addWord(this.parseWord(sentence.substring(start, i)));
                    }
                    start = i;
                    flag = 2;
                } else {
                    if (flag == 2) {
                        newSent.addWord(this.parseWord(sentence.substring(start, i)));
                        start = i;
                    } else if (flag == 1 || flag == 0) {
                        start = i;
                    }
                    flag = 3;
                }
            }
            ++i;
        }
        if (flag >= 2 && len - 1 > start) {
            newSent.addWord(this.parseWord(sentence.substring(start, len - 1)));
        }
        return newSent;
    }

    protected Word parseWord(String content) {
        Word cur = new Word(content);
        if (this.isNumber(content)) {
            cur.setType(2);
        } else if (content.length() == 1 && punctuations.indexOf(content) >= 0) {
            cur.setType(4);
        }
        return cur;
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList parseTokens(String content) {
        if (content == null) {
            return null;
        }
        if ((content = content.trim()).length() == 0) {
            return null;
        }
        len = content.length();
        flag = 0;
        start = 0;
        tokenList = new ArrayList<String>();
        checkPeriod = this.wordDelimitor.indexOf(46) < 0;
        checkApostrophes = this.wordDelimitor.indexOf(39) < 0;
        i = 0;
        while (i < len) {
            block13: {
                block12: {
                    ch = content.charAt(i);
                    if (!checkPeriod || ch != '.') break block12;
                    if (this.isPeriodAsToken(i, start, content)) ** GOTO lbl-1000
                    if (flag >= 2) {
                        tokenList.add(content.substring(start, i));
                    }
                    flag = 1;
                    break block13;
                }
                if (checkApostrophes && ch == '\'' && (ret = this.isApostrophesAsWord(i, start, content)) < 2) {
                    if (flag >= 2) {
                        tokenList.add(content.substring(start, i));
                    }
                    flag = 1;
                } else if (this.wordDelimitor.indexOf(ch) >= 0) {
                    if (flag >= 2) {
                        tokenList.add(content.substring(start, i));
                    }
                    flag = 1;
                } else if (flag == 1 || flag == 0) {
                    start = i;
                    flag = 2;
                }
            }
            ++i;
        }
        if (flag >= 2) {
            tokenList.add(content.substring(start, len));
        }
        return tokenList;
    }

    protected boolean isPeriodAsWord(int periodPos, int startPos, String context) {
        char ch;
        int len = context.length();
        if (periodPos == startPos || !Character.isLetter(context.charAt(periodPos - 1)) || context.charAt(periodPos - 1) > '\u00ff') {
            return false;
        }
        if (periodPos - 2 > 0 && context.charAt(periodPos - 2) == '.') {
            return true;
        }
        if (periodPos == startPos + 1) {
            return true;
        }
        if (periodPos - startPos >= 4) {
            return false;
        }
        return !(periodPos < len - 2 ? (ch = context.charAt(periodPos + 1)) == '\r' || ch == '\n' : periodPos == len - 1);
    }

    protected boolean isPeriodAsToken(int periodPos, int startPos, String context) {
        int len = context.length();
        if (periodPos == startPos || !Character.isLetter(context.charAt(periodPos - 1)) || context.charAt(periodPos - 1) > '\u00ff') {
            return false;
        }
        if (periodPos > 2 && context.charAt(periodPos - 2) == '.') {
            return true;
        }
        if (periodPos - startPos >= 4) {
            return false;
        }
        if (periodPos < len - 1) {
            return Character.isLetter(context.charAt(periodPos + 1));
        }
        return false;
    }

    protected int isApostrophesAsWord(int apoPos, int startPos, String context) {
        if (apoPos == 0 || context.charAt(apoPos - 1) == ' ' || apoPos == context.length() - 1) {
            return 0;
        }
        char ch = context.charAt(apoPos + 1);
        if (ch == ' ' || !Character.isLetter(ch)) {
            return 0;
        }
        if (ch == 's' && apoPos + 2 < context.length() && context.charAt(apoPos + 2) == ' ') {
            return 1;
        }
        return 2;
    }

    protected boolean isSentencePeriod(int pos, String context) {
        int start;
        if (pos == 0) {
            return false;
        }
        if (context.charAt(pos - 1) > '\u00ff') {
            return true;
        }
        int len = context.length();
        if (pos < len - 1 && context.charAt(pos + 1) != ' ') {
            return false;
        }
        if (Character.isUpperCase(context.charAt(pos - 1)) && (pos == 1 || Character.isWhitespace(context.charAt(pos - 2)))) {
            return false;
        }
        if (pos - 2 > 0 && context.charAt(pos - 2) == '.') {
            return false;
        }
        return pos >= len - 2 || this.isUpper(context.charAt(pos + 2)) || (start = context.lastIndexOf(32, pos)) < 0 || pos - start > 5 || !this.isUpper(context.charAt(start + 1));
    }

    private boolean isUpper(char ch) {
        return ch < 'a' || ch > 'z';
    }

    protected boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

