/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Sentence;
import dragon.nlp.Term;
import dragon.nlp.Word;
import dragon.nlp.extract.EngDocumentParser;
import dragon.nlp.tool.MedPostTagger;
import java.util.ArrayList;

public class CoordinatingChecker {
    private int threshold = 4;
    private int minCommaNum = 2;

    public static void main(String[] args) {
        CoordinatingChecker checker = new CoordinatingChecker();
        Sentence sent = new EngDocumentParser().parseSentence("Obesity and type 2 diabetes mellitus are associated with many metabolic disorders including insulin resistance, dyslipidemia, hypertension or atherosclerosis");
        MedPostTagger tagger = new MedPostTagger(System.getProperty("user.dir"));
        tagger.tag(sent);
        checker.identifyParaElements(sent);
        Word curWord = sent.getFirstWord();
        while (curWord != null) {
            System.out.print(curWord.getContent());
            System.out.print(" ");
            System.out.print(curWord.getParallelGroup());
            System.out.print("\r\n");
            curWord = curWord.next;
        }
    }

    public int identifyParaElements(Sentence sent) {
        int commaNum = 0;
        int groupNo = 0;
        int offset = 0;
        int firstComma = -1;
        int lastComma = -1;
        Word cur = sent.getFirstWord();
        while (cur != null) {
            if (cur.isPunctuation() && cur.getContent().equalsIgnoreCase(",")) {
                if (commaNum == 0) {
                    commaNum = 1;
                    firstComma = offset;
                    lastComma = offset;
                } else if (offset <= lastComma + this.threshold + 1) {
                    ++commaNum;
                    lastComma = offset;
                } else if (commaNum < this.minCommaNum) {
                    commaNum = 1;
                    firstComma = offset;
                    lastComma = offset;
                } else if (this.processParallelGroup(sent, groupNo, firstComma, lastComma, commaNum)) {
                    ++groupNo;
                    commaNum = 1;
                    firstComma = offset;
                    lastComma = offset;
                }
            }
            ++offset;
            cur = cur.next;
        }
        if (commaNum >= this.minCommaNum && this.processParallelGroup(sent, groupNo, firstComma, lastComma, commaNum)) {
            ++groupNo;
        }
        return groupNo;
    }

    private boolean processParallelGroup(Sentence sent, int groupNo, int firstComma, int lastComma, int commaNum) {
        Word end;
        Word start;
        int pos;
        if (firstComma <= 0) {
            return false;
        }
        Word cur = sent.getWord(firstComma - 1);
        int step = 0;
        while (cur != null) {
            pos = cur.getPOSIndex();
            if (pos == 2 || pos == 4 || pos == 5 || pos == 0 || pos == 8) break;
            cur = cur.prev;
            ++step;
        }
        if (step == 0) {
            start = cur.next.next;
            --commaNum;
        } else {
            start = cur == null ? sent.getFirstWord() : cur.next;
        }
        cur = sent.getWord(lastComma + 1);
        step = 0;
        while (cur != null) {
            pos = cur.getPOSIndex();
            if (pos == 2 || pos == 4 || pos == 5 || pos == 0 || pos == 8 && !cur.getContent().equalsIgnoreCase("and") && !cur.getContent().equalsIgnoreCase("or")) break;
            cur = cur.next;
            ++step;
        }
        if (step == 0) {
            end = cur.prev.prev;
            --commaNum;
        } else {
            end = cur == null ? sent.getLastWord() : cur.prev;
        }
        if (commaNum < this.minCommaNum) {
            return false;
        }
        cur = start;
        while (!cur.equals(end)) {
            cur.setParallelGroup(groupNo);
            cur = cur.next;
        }
        end.setParallelGroup(groupNo);
        return true;
    }

    public ArrayList parallelTermPredict(ArrayList termList) {
        int i = 0;
        while (i < termList.size()) {
            Term curTerm = (Term)termList.get(i);
            int curParaGroup = curTerm.getStartingWord().getParallelGroup();
            if (curParaGroup >= 0) {
                Term newTerm;
                Word curWord;
                Word endWord = curWord = curTerm.getStartingWord().prev;
                Word prevWord = curTerm.getStartingWord();
                int insertPos = i;
                while (endWord != null && curWord != null && curWord.getParallelGroup() == curParaGroup && curWord.getAssociatedConcept() == null) {
                    if (curWord.getContent().equalsIgnoreCase(",") || curWord.getContent().equalsIgnoreCase("and")) {
                        if (!curWord.equals(endWord)) {
                            newTerm = new Term(prevWord, endWord);
                            newTerm.setPredictedTerm(true);
                            termList.add(insertPos, newTerm);
                            prevWord.setAssociatedConcept(newTerm);
                            ++i;
                        }
                        endWord = curWord.prev;
                    }
                    prevWord = curWord;
                    curWord = curWord.prev;
                }
                if ((curWord == null || curWord.getParallelGroup() != curParaGroup) && endWord != null && prevWord.getPosInSentence() <= endWord.getPosInSentence()) {
                    newTerm = new Term(prevWord, endWord);
                    newTerm.setPredictedTerm(true);
                    termList.add(insertPos, newTerm);
                    prevWord.setAssociatedConcept(newTerm);
                    ++i;
                }
                Word startWord = curWord = curTerm.getStartingWord().next;
                prevWord = curTerm.getStartingWord();
                insertPos = i + 1;
                while (startWord != null && curWord != null && curWord.getParallelGroup() == curParaGroup && curWord.getAssociatedConcept() == null) {
                    if (curWord.getContent().equalsIgnoreCase(",") || curWord.getContent().equalsIgnoreCase("and")) {
                        if (!curWord.equals(startWord)) {
                            newTerm = new Term(startWord, prevWord);
                            newTerm.setPredictedTerm(true);
                            termList.add(insertPos, newTerm);
                            prevWord.setAssociatedConcept(newTerm);
                            ++i;
                        }
                        startWord = curWord.next;
                    }
                    prevWord = curWord;
                    curWord = curWord.next;
                }
                if ((curWord == null || curWord.getParallelGroup() != curParaGroup) && startWord != null && prevWord.getPosInSentence() >= startWord.getPosInSentence()) {
                    newTerm = new Term(startWord, prevWord);
                    newTerm.setPredictedTerm(true);
                    termList.add(insertPos, newTerm);
                    prevWord.setAssociatedConcept(newTerm);
                    ++i;
                }
            }
            ++i;
        }
        return termList;
    }
}

