/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Term;
import dragon.nlp.Word;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.util.ArrayList;

public class CompoundTermFinder {
    private SortedArray suffixList;
    private boolean subterm_enabled;

    public CompoundTermFinder() {
        this.suffixList = null;
        this.subterm_enabled = false;
    }

    public CompoundTermFinder(String suffixFile) {
        this.suffixList = this.loadlist(suffixFile);
        this.subterm_enabled = false;
    }

    public void setSubTermOption(boolean option) {
        this.subterm_enabled = option;
    }

    public boolean getSubTermOption() {
        return this.subterm_enabled;
    }

    protected ArrayList predict(ArrayList termList) {
        if (termList.size() <= 1) {
            return termList;
        }
        ArrayList newList = new ArrayList(termList.size());
        int start = 0;
        while (start < termList.size()) {
            Term term;
            int end = this.searchEndTerm(termList, start);
            if (this.suffixList != null && end > start) {
                term = (Term)termList.get(end);
                while (end > start && term.getWordNum() == 1 && !this.suffixList.contains(term.toLemmaString())) {
                    term = (Term)termList.get(--end);
                }
            }
            if (end == start) {
                newList.add(termList.get(start));
            } else {
                Word startingWord = ((Term)termList.get(start)).getStartingWord();
                Word endingWord = ((Term)termList.get(end)).getEndingWord();
                term = new Term(startingWord, endingWord);
                term.setPredictedTerm(true);
                term.getStartingWord().setAssociatedConcept(term);
                newList.add(term);
                int i = start;
                while (i <= end) {
                    term = (Term)termList.get(i);
                    if (i > start) {
                        term.getStartingWord().setAssociatedConcept(null);
                    }
                    term.setSubConcept(true);
                    if (this.subterm_enabled) {
                        newList.add(term);
                    }
                    ++i;
                }
            }
            start = this.getNextNonSubTerm(termList, end + 1);
        }
        return newList;
    }

    private int searchEndTerm(ArrayList termList, int start) {
        Term curTerm = (Term)termList.get(start);
        int end = start;
        start = this.getNextNonSubTerm(termList, start + 1);
        Word nextWord = curTerm.getEndingWord().next;
        int skippedWords = 0;
        while (start < termList.size() && nextWord != null) {
            Term nextTerm = (Term)termList.get(start);
            if (nextTerm.getStartingWord().equals(nextWord)) {
                end = start;
                curTerm = nextTerm;
                start = this.getNextNonSubTerm(termList, start + 1);
                skippedWords = 0;
                nextWord = curTerm.getEndingWord().next;
                continue;
            }
            if (skippedWords >= 1) {
                return end;
            }
            int posIndex = nextWord.getPOSIndex();
            if (posIndex == 3 || posIndex == 1) {
                ++skippedWords;
                nextWord = nextWord.next;
                continue;
            }
            if (posIndex == 0 && ".-".indexOf(nextWord.getContent()) >= 0) {
                nextWord = nextWord.next;
                continue;
            }
            return end;
        }
        return end;
    }

    private int getNextNonSubTerm(ArrayList list2, int start) {
        int i = start;
        while (i < list2.size()) {
            if (!((Term)list2.get(i)).isSubConcept()) break;
            ++i;
        }
        return i;
    }

    private SortedArray loadlist(String filename) {
        try {
            if (filename == null || filename.trim().length() == 0) {
                return null;
            }
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine();
            int total = Integer.parseInt(line);
            SortedArray list2 = new SortedArray(total);
            int i = 0;
            while (i < total) {
                line = br.readLine();
                int pos = line.indexOf(9);
                if (pos > 0) {
                    line = line.substring(0, pos);
                }
                list2.add(line.trim());
                ++i;
            }
            br.close();
            return list2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

