/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Sentence;
import dragon.nlp.Word;
import dragon.nlp.extract.EngDocumentParser;
import dragon.nlp.tool.MedPostTagger;

public class ClauseFinder {
    String[] arrConj = new String[this.conjNum];
    int conjNum = 9;
    Sentence sent;

    public static void main(String[] args) {
        ClauseFinder finder = new ClauseFinder();
        Sentence sent = new EngDocumentParser().parseSentence("I like him");
        MedPostTagger tagger = new MedPostTagger(System.getProperty("user.dir"));
        tagger.tag(sent);
        finder.clauseIdentify(sent);
        Word curWord = sent.getFirstWord();
        while (curWord != null) {
            System.out.print(curWord.getContent());
            System.out.print(" ");
            System.out.print(curWord.getClauseID());
            System.out.print("\r\n");
            curWord = curWord.next;
        }
    }

    public ClauseFinder() {
        this.arrConj[0] = "although";
        this.arrConj[1] = "because";
        this.arrConj[2] = "but";
        this.arrConj[3] = "if";
        this.arrConj[4] = "that";
        this.arrConj[5] = "though";
        this.arrConj[6] = "when";
        this.arrConj[7] = "whether";
        this.arrConj[8] = "while";
    }

    public int clauseIdentify(Sentence sent) {
        int clauseID = 0;
        Word openner = sent.getFirstWord();
        Word cur = sent.getFirstWord();
        while (cur != null) {
            boolean newClause = false;
            int pos = cur.getPOSIndex();
            if (pos == 8) {
                newClause = this.processConjunction(cur);
                if (newClause) {
                    openner = cur;
                }
            } else if (cur.isPunctuation() && cur.getContent().equalsIgnoreCase(",")) {
                newClause = this.processComma(cur, openner);
                if (newClause) {
                    openner = null;
                }
            } else if ((pos == 0 || pos >= 4) && cur.getContent().equalsIgnoreCase("that")) {
                newClause = this.processThat(cur);
            }
            if (newClause) {
                ++clauseID;
            }
            cur.setClauseID(clauseID);
            cur = cur.next;
        }
        return clauseID + 1;
    }

    private boolean processConjunction(Word current) {
        if (current.prev == null || current.next == null) {
            return false;
        }
        int index = this.isConjunctionMarker(current.getContent());
        return index >= 0;
    }

    private boolean processComma(Word current, Word openner) {
        if (current.prev == null || current.next == null) {
            return false;
        }
        if (current.prev.getPOSIndex() == 9 || current.next.getPOSIndex() == 9) {
            return false;
        }
        if (current.getParallelGroup() >= 0) {
            return false;
        }
        if (openner == null) {
            return false;
        }
        int pos = openner.getPOSIndex();
        return pos == 5 || pos == 8 || pos == 4;
    }

    private boolean processThat(Word current) {
        if (current.prev == null || current.next == null) {
            return false;
        }
        int prevPos = current.prev.getPOSIndex();
        if (prevPos == 2 || prevPos == 8 || prevPos == 4) {
            return true;
        }
        if (prevPos == 1) {
            current.setAssociatedConcept(current.prev.getAssociatedConcept());
            return true;
        }
        return false;
    }

    private int isConjunctionMarker(String word) {
        int low = 0;
        int high = this.conjNum - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            int result2 = this.arrConj[middle].compareToIgnoreCase(word);
            if (result2 == 0) {
                return middle;
            }
            if (result2 > 0) {
                high = middle - 1;
                continue;
            }
            low = middle + 1;
        }
        return -1;
    }
}

