/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Sentence;
import dragon.nlp.Term;
import dragon.nlp.Triple;
import dragon.nlp.Word;
import dragon.nlp.extract.AbstractTripleExtractor;
import dragon.nlp.extract.TermExtractor;
import dragon.nlp.ontology.SemanticNet;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.PrintWriter;
import java.util.ArrayList;

public class BasicTripleExtractor
extends AbstractTripleExtractor {
    private SemanticNet snNet;

    public BasicTripleExtractor(TermExtractor te) {
        super(te);
        this.snNet = te.getOntology().getSemanticNet();
    }

    public void extractTripleFromFile(String filename) {
        try {
            String workDir = System.getProperty("user.dir");
            this.extractFromDoc(FileUtil.readTextFile(workDir + "/inout/" + filename));
            PrintWriter out = FileUtil.getPrintWriter(workDir + "/inout/" + filename + ".triple");
            this.print(out, this.conceptList, this.tripleList);
            out.close();
            PrintWriter mergedOut = FileUtil.getPrintWriter(workDir + "/inout/" + filename + ".mergedtriple");
            SortedArray mergedTermList = this.conceptExtractor.mergeConceptByEntryID(this.conceptList);
            this.print(mergedOut, mergedTermList, this.mergeTriples(mergedTermList, this.tripleList));
            mergedOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void print(PrintWriter out, ArrayList termList, ArrayList tripleList) {
        try {
            String[] arrStr;
            int j;
            int i = 0;
            while (i < termList.size()) {
                Term term = (Term)termList.get(i);
                out.write(term.toString());
                j = 0;
                while (j < term.getAttributeNum()) {
                    out.write(47);
                    out.write(term.getAttribute(j).toString());
                    ++j;
                }
                out.write(40);
                out.write(String.valueOf(term.getFrequency()));
                out.write(41);
                arrStr = term.getCandidateTUI();
                if (arrStr != null) {
                    out.write(": ");
                    j = 0;
                    while (j < arrStr.length) {
                        out.write(arrStr[j]);
                        if (j == arrStr.length - 1) {
                            out.write(" (");
                        } else {
                            out.write(59);
                        }
                        ++j;
                    }
                    arrStr = term.getCandidateCUI();
                    j = 0;
                    while (j < arrStr.length) {
                        out.write(arrStr[j]);
                        if (term.getCUI() != null && term.getCUI().equalsIgnoreCase(arrStr[j])) {
                            out.write("*");
                        }
                        if (j == arrStr.length - 1) {
                            out.write(41);
                        } else {
                            out.write(44);
                        }
                        ++j;
                    }
                }
                if (term.isPredicted()) {
                    out.write("(Predicted)");
                }
                out.write("\r\n");
                ++i;
            }
            i = 0;
            while (i < tripleList.size()) {
                Triple triple2 = (Triple)tripleList.get(i);
                arrStr = triple2.getCandidateTUI();
                out.write(triple2.getFirstConcept().toString());
                out.write("<->");
                out.write(triple2.getSecondConcept().toString());
                out.write(40);
                out.write(String.valueOf(triple2.getFrequency()));
                out.write(41);
                if (arrStr != null) {
                    out.write(": ");
                    j = 0;
                    while (j < arrStr.length) {
                        out.write(arrStr[j]);
                        if (j < arrStr.length - 1) {
                            out.write(59);
                        }
                        ++j;
                    }
                }
                out.write("\r\n");
                ++i;
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList extractFromSentence(Sentence sent) {
        if (this.clauseIdentify_enabled) {
            this.clauseFinder.clauseIdentify(sent);
        }
        Boolean trueObj = new Boolean(true);
        Boolean falseObj = new Boolean(false);
        Word next2 = sent.getFirstWord();
        while (next2 != null) {
            Term term = (Term)next2.getAssociatedConcept();
            if (term != null) {
                if (this.conceptFilter_enabled && this.cf != null) {
                    if (this.cf.keep(term)) {
                        term.setMemo(trueObj);
                    } else {
                        term.setMemo(falseObj);
                    }
                } else {
                    term.setMemo(trueObj);
                }
                if (term.getWordNum() == 1 && term.getStartingWord().getPOSIndex() == 3) {
                    term.setMemo(falseObj);
                }
            }
            next2 = next2.next;
        }
        ArrayList<Triple> list2 = new ArrayList<Triple>();
        Word first = sent.getFirstWord();
        while (first != null) {
            if (first.getAssociatedConcept() == null || first.getAssociatedConcept().getMemo().equals(falseObj)) {
                first = first.next;
                continue;
            }
            int firstGroup = first.getParallelGroup();
            Word second = first.next;
            while (second != null) {
                if (second.getAssociatedConcept() == null || second.getAssociatedConcept().getMemo().equals(falseObj)) {
                    second = second.next;
                    continue;
                }
                if (second.getAssociatedConcept().equalTo(first.getAssociatedConcept())) break;
                int secondGroup = second.getParallelGroup();
                if (this.coordinatingCheck_enabled) {
                    if (secondGroup != -1 && firstGroup == secondGroup) {
                        second = second.next;
                        continue;
                    }
                    if (this.checkCoordinateTerms((Term)first.getAssociatedConcept(), (Term)second.getAssociatedConcept())) {
                        second = second.next;
                        continue;
                    }
                }
                if (this.clauseIdentify_enabled && first.getClauseID() != second.getClauseID()) {
                    second = second.next;
                    continue;
                }
                Triple triple2 = this.lookup((Term)first.getAssociatedConcept(), (Term)second.getAssociatedConcept());
                if (triple2 != null) {
                    list2.add(triple2);
                }
                second = second.next;
            }
            first = first.next;
        }
        return list2;
    }

    private Triple lookup(Term first, Term second) {
        try {
            if (!this.semanticCheck_enabled) {
                return new Triple(first, second);
            }
            if (first.getCandidateTUI() == null || second.getCandidateTUI() == null) {
                return new Triple(first, second);
            }
            if (this.relationCheck_enabled) {
                String[] rel2 = first.getTUI() != null && second.getTUI() != null ? this.snNet.getRelations(first.getTUI(), second.getTUI()) : this.snNet.getRelations(first.getCandidateTUI(), second.getCandidateTUI());
                if (rel2 != null) {
                    Triple triple2 = new Triple(first, second);
                    triple2.setCandidateTUI(rel2);
                    return triple2;
                }
                return null;
            }
            boolean found = first.getTUI() != null && second.getTUI() != null ? this.snNet.isSemanticRelated(first.getTUI(), second.getTUI()) : this.snNet.isSemanticRelated(first.getCandidateTUI(), second.getCandidateTUI());
            if (found) {
                Triple triple2 = new Triple(first, second);
                return triple2;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

