/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Sentence;
import dragon.nlp.Term;
import dragon.nlp.Word;
import dragon.nlp.extract.EngDocumentParser;
import java.util.TreeMap;

public class Abbreviation {
    private TreeMap abbrList = new TreeMap();
    private Term referringTerm;
    private char firstUpperChar;
    private char lastUpperChar;

    public static void main(String[] args) {
        Abbreviation abbr = new Abbreviation();
        Sentence sent = new EngDocumentParser().parseSentence("divalent metal transporter (DMT1).");
        Term term = new Term(sent.getFirstWord(), sent.getWord(2));
        abbr.isAbbrOfLastTerm(sent.getWord(4), term);
    }

    public void clearCachedAbbr() {
        this.abbrList.clear();
    }

    public boolean contains(String abbr) {
        if (abbr.charAt(abbr.length() - 1) == 's') {
            abbr = abbr.substring(0, abbr.length() - 1);
        }
        this.referringTerm = (Term)this.abbrList.get(abbr.toUpperCase());
        return this.referringTerm != null;
    }

    public boolean isAbbrOfLastTerm(Word word, Term lastTerm) {
        if (lastTerm == null) {
            return false;
        }
        if (word.prev == null) {
            return false;
        }
        if (word.next == null) {
            return false;
        }
        if (!word.prev.getContent().equalsIgnoreCase("(")) {
            return false;
        }
        if (!word.next.getContent().equalsIgnoreCase(")")) {
            return false;
        }
        if (!word.prev.prev.equals(lastTerm.getEndingWord())) {
            return false;
        }
        String abbr = word.getContent();
        int upperCharNum = this.analyzeUpperLetter(abbr);
        if (upperCharNum < 2 || upperCharNum > lastTerm.getWordNum()) {
            return false;
        }
        if (!this.equalCharIgnoreCase(lastTerm.getStartingWord().getContent().charAt(0), this.firstUpperChar)) {
            return false;
        }
        return this.equalCharIgnoreCase(lastTerm.getEndingWord().getContent().charAt(0), this.lastUpperChar);
    }

    public void put(String abbr, Term associatedTerm) {
        if (abbr.charAt(abbr.length() - 1) == 's') {
            abbr = abbr.substring(0, abbr.length() - 1);
        }
        if (!this.abbrList.containsKey(abbr.toUpperCase())) {
            this.abbrList.put(abbr.toUpperCase(), associatedTerm);
        }
    }

    public Term get() {
        return this.referringTerm;
    }

    public Term get(String abbr) {
        Term cur = (Term)this.abbrList.get(abbr.toUpperCase());
        return cur;
    }

    private boolean equalCharIgnoreCase(char a, char b) {
        return a == b || Math.abs(a - b) == 32;
    }

    private int analyzeUpperLetter(String abbr) {
        int count2 = 0;
        this.firstUpperChar = '\u0000';
        this.lastUpperChar = '\u0000';
        int i = 0;
        while (i < abbr.length()) {
            if (Character.isUpperCase(abbr.charAt(i))) {
                ++count2;
                if (this.firstUpperChar == '\u0000') {
                    this.firstUpperChar = abbr.charAt(i);
                }
                this.lastUpperChar = abbr.charAt(i);
            }
            ++i;
        }
        return count2;
    }
}

