/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp;

import dragon.nlp.Concept;
import dragon.nlp.Word;
import dragon.nlp.compare.SortedElement;
import dragon.nlp.compare.TermLemmaComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;
import java.util.Collections;

public class Term
implements Concept,
Comparable,
SortedElement {
    public static final int NAME_ASIS = 0;
    public static final int NAME_LEMMA = 1;
    public static final int NAME_NORM = 2;
    private static int nameMode = 2;
    private Word starting;
    private Word ending;
    private Term referral;
    private Object memo;
    private SortedArray attributes;
    private String normalizedStr;
    private String[] can_cui;
    private String cui;
    private String[] can_tui;
    private String tui;
    private int freq;
    private double weight;
    private int len;
    private int index;
    private boolean predicted;
    private boolean expired;
    private boolean subterm;

    public Term(Word starting, Word ending) {
        this.starting = starting;
        this.ending = ending;
        this.attributes = null;
        this.tui = null;
        this.cui = null;
        this.weight = 0.0;
        this.predicted = false;
        this.freq = 1;
        this.index = 0;
        this.len = 1;
        this.memo = null;
        this.expired = false;
        this.normalizedStr = null;
        this.referral = null;
        this.subterm = false;
        Word next2 = starting;
        while (!next2.equals(ending)) {
            ++this.len;
            next2 = next2.next;
        }
    }

    public Term(Word word) {
        this.starting = word;
        this.ending = word;
        this.attributes = null;
        this.tui = null;
        this.cui = null;
        this.predicted = false;
        this.freq = 1;
        this.index = 0;
        this.memo = null;
        this.expired = false;
        this.weight = 0.0;
        this.normalizedStr = null;
        this.referral = null;
        this.len = 1;
    }

    public Concept copy() {
        Term newTerm = new Term(this.getStartingWord(), this.getEndingWord());
        newTerm.setReferral(this.getReferral());
        newTerm.setFrequency(this.getFrequency());
        newTerm.setCUI(this.getCUI());
        newTerm.setCandidateCUI(this.getCandidateCUI());
        newTerm.setTUI(this.getTUI());
        newTerm.setCandidateTUI(this.getCandidateTUI());
        newTerm.setSubConcept(this.isSubConcept());
        return newTerm;
    }

    public int getConceptType() {
        return 1;
    }

    public static void setNameMode(int mode) {
        if (mode < 0 || mode > 2) {
            return;
        }
        nameMode = mode;
    }

    public int compareTo(Object obj) {
        String objValue = ((Term)obj).toString();
        return this.toString().compareToIgnoreCase(objValue);
    }

    public int compareTo(Term term) {
        return this.toString().compareToIgnoreCase(term.toString());
    }

    public boolean isSubConcept() {
        return this.subterm;
    }

    public void setSubConcept(boolean subterm) {
        this.subterm = subterm;
    }

    public String getName() {
        if (nameMode == 0) {
            return this.toString();
        }
        if (nameMode == 1) {
            return this.toLemmaString();
        }
        return this.toNormalizedString();
    }

    public String getEntryID() {
        if (this.cui != null) {
            return this.cui;
        }
        if (this.can_cui != null) {
            return this.can_cui[0];
        }
        return null;
    }

    public String getSemanticType() {
        if (this.tui != null) {
            return this.tui;
        }
        if (this.can_tui != null) {
            return this.can_tui[0];
        }
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isPredicted() {
        return this.predicted;
    }

    public void setPredictedTerm(boolean predicted) {
        this.predicted = predicted;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public String[] getCandidateCUI() {
        return this.can_cui;
    }

    public String getCandidateCUI(int index) {
        return this.can_cui[index];
    }

    public int getCandidateCUINum() {
        if (this.can_cui == null) {
            return 0;
        }
        return this.can_cui.length;
    }

    public void setCandidateCUI(String[] can_cui) {
        this.can_cui = can_cui;
    }

    public String getCUI() {
        return this.cui;
    }

    public void setCUI(String cui) {
        this.cui = cui;
    }

    public int getSenseNum() {
        if (this.can_cui == null) {
            return 0;
        }
        return this.can_cui.length;
    }

    public String[] getCandidateTUI() {
        return this.can_tui;
    }

    public String getCandidateTUI(int index) {
        return this.can_tui[index];
    }

    public int getCandidateTUINum() {
        if (this.can_tui == null) {
            return 0;
        }
        return this.can_tui.length;
    }

    public void setCandidateTUI(String[] can_tui) {
        this.can_tui = can_tui;
    }

    public String getTUI() {
        return this.tui;
    }

    public void setTUI(String tui) {
        this.tui = tui;
    }

    public Word getStartingWord() {
        return this.starting;
    }

    public Word getEndingWord() {
        return this.ending;
    }

    public Object getMemo() {
        return this.memo;
    }

    public void setMemo(Object memo) {
        this.memo = memo;
    }

    public Term getReferral() {
        return this.referral;
    }

    public void setReferral(Term referral) {
        this.referral = referral;
    }

    public String toString() {
        StringBuffer term = new StringBuffer(this.starting.getContent());
        Word next2 = this.starting;
        boolean lastPunctuation = false;
        while (!next2.equals(this.ending)) {
            next2 = next2.next;
            if (next2.isPunctuation()) {
                term.append(next2.getContent());
                lastPunctuation = true;
                continue;
            }
            if (lastPunctuation) {
                term.append(next2.getContent());
            } else {
                term.append(' ');
                term.append(next2.getContent());
            }
            lastPunctuation = false;
        }
        return term.toString();
    }

    public String toLemmaString() {
        if (this.referral != null) {
            return this.referral.toLemmaString();
        }
        Word next2 = this.starting;
        String term = next2.getLemma();
        while (!next2.equals(this.ending)) {
            next2 = next2.next;
            term = term + " " + next2.getLemma();
        }
        return term;
    }

    public void setNormalizedString(String normalizedStr) {
        this.normalizedStr = normalizedStr;
    }

    public String toNormalizedString() {
        if (this.referral != null) {
            return this.referral.toNormalizedString();
        }
        if (this.normalizedStr != null) {
            return this.normalizedStr;
        }
        if (this.starting.equals(this.ending)) {
            return this.starting.getLemma();
        }
        ArrayList<String> list2 = new ArrayList<String>(4);
        Word next2 = this.starting;
        while (next2 != null) {
            if (!next2.canIgnore()) {
                if (next2.getLemma() != null) {
                    list2.add(next2.getLemma());
                } else {
                    list2.add(next2.getContent().toLowerCase());
                }
            }
            if (next2.equals(this.ending)) break;
            next2 = next2.next;
        }
        Collections.sort(list2);
        StringBuffer term = new StringBuffer((String)list2.get(0));
        int i = 1;
        while (i < list2.size()) {
            term.append(' ');
            term.append((String)list2.get(i));
            ++i;
        }
        this.normalizedStr = term.toString();
        return this.normalizedStr;
    }

    public int getWordNum() {
        return this.len;
    }

    public void addFrequency(int inc) {
        this.freq += inc;
    }

    public int getFrequency() {
        return this.freq;
    }

    public void setFrequency(int freq) {
        this.freq = freq;
    }

    public boolean equalTo(Concept concept) {
        String objFirst = this.getEntryID();
        String objSecond = concept.getEntryID();
        if (objFirst != null && objSecond != null) {
            return objFirst.equalsIgnoreCase(objSecond);
        }
        return this.getName().equalsIgnoreCase(concept.getName());
    }

    public int getAttributeNum() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public int getAttributeOccurrence() {
        if (this.getAttributeNum() == 0) {
            return 0;
        }
        int count2 = 0;
        int i = 0;
        while (i < this.getAttributeNum()) {
            count2 += this.getAttribute(i).getFrequency();
            ++i;
        }
        return count2;
    }

    public Term getAttribute(int index) {
        return (Term)this.attributes.get(index);
    }

    public void addAttribute(Term attr2) {
        if (this.attributes == null) {
            this.attributes = new SortedArray(2, new TermLemmaComparator());
            this.attributes.add(attr2);
        } else if (!this.attributes.add(attr2)) {
            Term cur = (Term)this.attributes.get(this.attributes.insertedPos());
            cur.addFrequency(attr2.getFrequency());
        }
    }

    public int hashCode() {
        if (this.index >= 0) {
            return this.index;
        }
        return super.hashCode();
    }
}

