/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

public class Window {
    private int start;
    private boolean startRelativeToLeft;
    private int end;
    private boolean endRelativeToLeft;
    private String winName = null;
    private int maxLength = Integer.MAX_VALUE;
    private int minLength = 1;

    public Window(int start, boolean startRelativeToLeft, int end, boolean endRelativeToLeft) {
        this(start, startRelativeToLeft, end, endRelativeToLeft, null);
        String startB = startRelativeToLeft ? "L" : "R";
        String endB = endRelativeToLeft ? "L" : "R";
        this.winName = startB + start + endB + end;
    }

    public Window(int start, boolean startRelativeToLeft, int end, boolean endRelativeToLeft, String winName) {
        this.start = start;
        this.startRelativeToLeft = startRelativeToLeft;
        this.end = end;
        this.endRelativeToLeft = endRelativeToLeft;
        this.winName = winName;
    }

    public Window(int start, boolean startRelativeToLeft, int end, boolean endRelativeToLeft, String winName, int minWinLength, int maxWinLength) {
        this(start, startRelativeToLeft, end, endRelativeToLeft, winName);
        this.maxLength = maxWinLength;
        this.minLength = minWinLength;
    }

    public int leftBoundary(int segStart, int segEnd) {
        if (this.startRelativeToLeft) {
            return this.boundary(segStart, this.start);
        }
        return this.boundary(segEnd, this.start);
    }

    public int rightBoundary(int segStart, int segEnd) {
        if (this.endRelativeToLeft) {
            return this.boundary(segStart, this.end);
        }
        return this.boundary(segEnd, this.end);
    }

    private int boundary(int boundary, int offset) {
        return boundary + offset;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String toString() {
        return this.winName;
    }
}

