/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.BasicToken;
import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.data.Dataset;
import dragon.ml.seqmodel.feature.AbstractFeatureType;
import dragon.ml.seqmodel.feature.BasicFeature;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureDictionary;
import dragon.ml.seqmodel.feature.FeatureDictionaryChar;
import dragon.ml.seqmodel.feature.FeatureIdentifier;

public class FeatureTypeWord
extends AbstractFeatureType {
    public static int RARE_THRESHOLD = 0;
    private FeatureDictionary dict;
    private String wordFile;
    private int stateNum;
    private int curState;
    private String token;
    private int tokenId;
    private boolean caseSensitive;

    public FeatureTypeWord(String wordFile, int stateNum) {
        this(wordFile, stateNum, false);
    }

    public FeatureTypeWord(String wordFile, int stateNum, boolean caseSensitive) {
        super(true);
        this.caseSensitive = caseSensitive;
        this.stateNum = stateNum;
        this.wordFile = wordFile;
        this.dict = new FeatureDictionaryChar(stateNum, 500);
        this.idPrefix = "W_";
    }

    public FeatureTypeWord(FeatureDictionary dict, int stateNum) {
        this(dict, stateNum, false);
    }

    public FeatureTypeWord(FeatureDictionary dict, int stateNum, boolean caseSensitive) {
        super(false);
        this.caseSensitive = caseSensitive;
        this.stateNum = stateNum;
        this.wordFile = null;
        this.dict = dict;
        this.idPrefix = "W_";
    }

    public FeatureDictionary getWordDictionary() {
        return this.dict;
    }

    public boolean startScanFeaturesAt(DataSequence data2, int startPos, int endPos) {
        this.curState = -1;
        if (startPos != endPos) {
            System.out.println("The starting position and the ending position should be the same for word features");
            return false;
        }
        this.tokenId = data2.getToken(endPos).getIndex();
        if (this.tokenId < 0) {
            this.token = data2.getToken(endPos).getContent();
            if (!this.caseSensitive) {
                this.token = this.token.toLowerCase();
            }
            this.tokenId = this.dict.getIndex(this.token);
        }
        if (this.tokenId < 0) {
            return false;
        }
        if (this.dict.getCount(this.tokenId) > RARE_THRESHOLD) {
            this.getNextState();
            return true;
        }
        return false;
    }

    public boolean hasNext() {
        return this.curState >= 0 && this.curState < this.stateNum;
    }

    public Feature next() {
        FeatureIdentifier id = new FeatureIdentifier(this.idPrefix + this.token, this.tokenId * this.stateNum + this.curState, this.curState);
        BasicFeature f2 = new BasicFeature(id, this.curState, 1.0);
        this.getNextState();
        return f2;
    }

    public boolean train(Dataset trainData) {
        trainData.startScan();
        while (trainData.hasNext()) {
            DataSequence seq2 = trainData.next();
            int pos = 0;
            while (pos < seq2.length()) {
                if (pos >= 0 && pos < seq2.length()) {
                    BasicToken token2 = seq2.getToken(pos);
                    int index = this.caseSensitive ? this.dict.addFeature(token2.getContent(), seq2.getLabel(pos)) : this.dict.addFeature(token2.getContent().toLowerCase(), seq2.getLabel(pos));
                    token2.setIndex(index);
                }
                ++pos;
            }
        }
        this.dict.finalize();
        return true;
    }

    public boolean readTrainingResult() {
        return this.dict.read(this.wordFile);
    }

    public boolean saveTrainingResult() {
        return this.dict.write(this.wordFile);
    }

    private void getNextState() {
        this.curState = this.needTraining() ? this.dict.getNextStateWithFeature(this.tokenId, this.curState) : ++this.curState;
    }

    public boolean supportSegment() {
        return false;
    }
}

