/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.AbstractFeatureTypeWrapper;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureIdentifier;
import dragon.ml.seqmodel.feature.FeatureType;
import dragon.ml.seqmodel.feature.Window;

public class FeatureTypeWindow
extends AbstractFeatureTypeWrapper {
    protected int currentWindow;
    protected int startPos;
    protected int endPos;
    protected transient DataSequence dataSeq;
    protected Window[] windows;
    private int dataLen;

    public FeatureTypeWindow(Window[] windows, FeatureType ftype) {
        super(ftype);
        this.windows = windows;
    }

    protected boolean advance(boolean firstCall) {
        while (firstCall || !this.ftype.hasNext()) {
            --this.currentWindow;
            if (this.currentWindow < 0) {
                return false;
            }
            if (this.windows[this.currentWindow].getMaxLength() < this.endPos + 1 - this.startPos || this.windows[this.currentWindow].getMinLength() > this.endPos + 1 - this.startPos) continue;
            int rightB = this.windows[this.currentWindow].rightBoundary(this.startPos, this.endPos);
            int leftB = this.windows[this.currentWindow].leftBoundary(this.startPos, this.endPos);
            if (leftB >= this.dataLen || rightB < 0 || leftB > rightB) continue;
            this.ftype.startScanFeaturesAt(this.dataSeq, Math.max(leftB, 0), Math.min(rightB, this.dataLen - 1));
            firstCall = false;
        }
        return true;
    }

    public boolean startScanFeaturesAt(DataSequence data2, int startPos, int endPos) {
        this.currentWindow = this.windows.length;
        this.dataSeq = data2;
        this.dataLen = this.dataSeq.length();
        this.startPos = startPos;
        this.endPos = endPos;
        return this.advance(true);
    }

    public boolean hasNext() {
        return this.ftype.hasNext() && this.currentWindow >= 0;
    }

    public Feature next() {
        Feature f2 = this.ftype.next();
        FeatureIdentifier id = f2.getID();
        id.setName(id.getName() + ".W." + this.windows[this.currentWindow]);
        id.setId(id.getId() * this.windows.length + this.currentWindow);
        this.advance(false);
        return f2;
    }
}

