/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.AbstractFeatureType;
import dragon.ml.seqmodel.feature.BasicFeature;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureDictionary;
import dragon.ml.seqmodel.feature.FeatureIdentifier;
import dragon.ml.seqmodel.feature.FeatureTypeWord;

public class FeatureTypeUnknownWord
extends AbstractFeatureType {
    private int curState;
    private FeatureDictionary dict;
    private int stateNum;
    private boolean caseSensitive;

    public FeatureTypeUnknownWord(FeatureDictionary d) {
        this(d, false);
    }

    public FeatureTypeUnknownWord(FeatureDictionary d, boolean caseSensitive) {
        super(false);
        this.caseSensitive = caseSensitive;
        this.dict = d;
        this.idPrefix = "UW";
        this.stateNum = d.getStateNum();
    }

    public boolean startScanFeaturesAt(DataSequence data2, int startPos, int endPos) {
        int count2;
        this.curState = this.stateNum;
        if (startPos != endPos) {
            System.out.println("The starting position and the ending position should be the same for unknown word features");
            return false;
        }
        if (data2.getToken(endPos).getIndex() >= 0) {
            count2 = this.dict.getCount(data2.getToken(endPos).getIndex());
        } else {
            String token2 = data2.getToken(endPos).getContent();
            if (!this.caseSensitive) {
                token2 = token2.toLowerCase();
            }
            count2 = this.dict.getCount(token2);
        }
        if (count2 > FeatureTypeWord.RARE_THRESHOLD + 1) {
            return false;
        }
        this.curState = 0;
        return true;
    }

    public boolean hasNext() {
        return this.curState < this.stateNum;
    }

    public Feature next() {
        FeatureIdentifier id = new FeatureIdentifier(this.idPrefix, this.curState, this.curState);
        BasicFeature f2 = new BasicFeature(id, this.curState, 1.0);
        ++this.curState;
        return f2;
    }

    public boolean supportSegment() {
        return false;
    }
}

