/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.AbstractFeatureType;
import dragon.ml.seqmodel.feature.BasicFeature;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureIdentifier;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class FeatureTypeRegexCount
extends AbstractFeatureType {
    private String[][] patternString = new String[][]{{"isInitCapitalWord", "[A-Z][a-z]+"}, {"isAllCapitalWord", "[A-Z][A-Z]+"}, {"isAllSmallCase", "[a-z]+"}, {"isWord", "[a-zA-Z][a-zA-Z]+"}, {"isAlphaNumeric", "[a-zA-Z0-9]+"}, {"singleCapLetter", "[A-Z]"}, {"isSpecialCharacter", "[#;:\\-/<>'\"()&]"}, {"singlePunctuation", "\\p{Punct}"}, {"singleDot", "[.]"}, {"singleComma", "[,]"}, {"containsDigit", ".*\\d+.*"}, {"isDigits", "\\d+"}};
    private Pattern[] p;
    private int[] patternOccurence;
    private int index;
    private int maxSegmentLength;

    public FeatureTypeRegexCount(int maxSegmentLength, String patternFile) {
        super(false);
        this.maxSegmentLength = maxSegmentLength;
        this.patternString = this.getPatterns(patternFile);
        this.p = new Pattern[this.patternString.length];
        int i = 0;
        while (i < this.patternString.length) {
            this.p[i] = Pattern.compile(this.patternString[i][1]);
            ++i;
        }
        this.patternOccurence = new int[this.patternString.length];
    }

    public FeatureTypeRegexCount(int maxSegmentLength, String[][] patternString) {
        super(false);
        this.maxSegmentLength = maxSegmentLength;
        this.patternString = patternString;
        this.p = new Pattern[patternString.length];
        int i = 0;
        while (i < patternString.length) {
            this.p[i] = Pattern.compile(patternString[i][1]);
            ++i;
        }
        this.patternOccurence = new int[patternString.length];
    }

    public FeatureTypeRegexCount(int maxSegmentLength) {
        super(false);
        this.maxSegmentLength = maxSegmentLength;
        this.p = new Pattern[this.patternString.length];
        int i = 0;
        while (i < this.patternString.length) {
            this.p[i] = Pattern.compile(this.patternString[i][1]);
            ++i;
        }
        this.patternOccurence = new int[this.patternString.length];
    }

    public boolean startScanFeaturesAt(DataSequence data2, int pos) {
        return this.startScanFeaturesAt(data2, pos, pos);
    }

    public boolean startScanFeaturesAt(DataSequence data2, int startPos, int endPos) {
        int j = 0;
        while (j < this.patternOccurence.length) {
            this.patternOccurence[j] = 0;
            ++j;
        }
        int i = startPos;
        while (i <= endPos) {
            j = 0;
            while (j < this.p.length) {
                if (this.p[j].matcher(data2.getToken(i).getContent()).matches()) {
                    int n = j;
                    this.patternOccurence[n] = this.patternOccurence[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        this.index = -1;
        return this.advance();
    }

    private boolean advance() {
        while (++this.index < this.patternOccurence.length && this.patternOccurence[this.index] <= 0) {
        }
        return this.index < this.patternOccurence.length;
    }

    public boolean hasNext() {
        return this.index < this.patternOccurence.length;
    }

    public Feature next() {
        int curLabel = -1;
        this.patternOccurence[this.index] = Math.min(this.maxSegmentLength, this.patternOccurence[this.index]);
        String name = this.patternString[this.index][0] + "_Count_" + this.patternOccurence[this.index];
        FeatureIdentifier id = new FeatureIdentifier(name, this.maxSegmentLength * (this.index + 1) + this.patternOccurence[this.index], curLabel);
        BasicFeature f2 = new BasicFeature(id, curLabel, 1.0);
        this.advance();
        return f2;
    }

    private String[][] getPatterns(String patternFile) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(patternFile));
            int len = Integer.parseInt(in.readLine());
            String[][] patterns = new String[len][2];
            int k = 0;
            while (k < len) {
                StringTokenizer strTokenizer = new StringTokenizer(in.readLine());
                patterns[k][0] = strTokenizer.nextToken();
                patterns[k][1] = strTokenizer.nextToken();
                ++k;
            }
            return patterns;
        }
        catch (IOException ioe) {
            System.err.println("Could not read pattern file : " + patternFile);
            ioe.printStackTrace();
            return null;
        }
    }
}

