/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.data.POSToken;
import dragon.ml.seqmodel.feature.AbstractFeatureType;
import dragon.ml.seqmodel.feature.BasicFeature;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureIdentifier;

public class FeatureTypePOSPattern
extends AbstractFeatureType {
    private int patternID;
    private int tagNum;
    private int maxSegmentLength;

    public FeatureTypePOSPattern(int stateNum, int tagNum) {
        this(stateNum, tagNum, 1);
    }

    public FeatureTypePOSPattern(int stateNum, int tagNum, int maxSegmentLength) {
        super(false);
        this.idPrefix = "PC_";
        this.maxSegmentLength = maxSegmentLength;
    }

    public boolean startScanFeaturesAt(DataSequence data2, int startPos, int endPos) {
        if (endPos - startPos + 1 > this.maxSegmentLength) {
            this.patternID = -1;
            return false;
        }
        this.patternID = this.getMultiTag(data2, startPos, endPos);
        return true;
    }

    public boolean hasNext() {
        return this.patternID >= 0;
    }

    public Feature next() {
        int curState = -1;
        FeatureIdentifier id = new FeatureIdentifier(this.idPrefix + String.valueOf(this.patternID), this.patternID, curState);
        BasicFeature f2 = new BasicFeature(id, curState, 1.0);
        this.patternID = -1;
        return f2;
    }

    private int getMultiTag(DataSequence data2, int startPos, int endPos) {
        int curMultiTag = ((POSToken)data2.getToken(startPos)).getPOSTag();
        int i = startPos + 1;
        while (i <= endPos) {
            int curTag = ((POSToken)data2.getToken(i)).getPOSTag();
            if (curTag < 0) {
                return -1;
            }
            curMultiTag = curMultiTag * this.tagNum + curTag;
            ++i;
        }
        return curMultiTag;
    }
}

