/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.AbstractFeatureType;
import dragon.ml.seqmodel.feature.BasicFeature;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureDictionary;
import dragon.ml.seqmodel.feature.FeatureIdentifier;
import dragon.ml.seqmodel.feature.FeatureTypeWord;

public class FeatureTypeKnownWord
extends AbstractFeatureType {
    private FeatureDictionary dict;
    private int stateNum;
    private int curState;
    private double wordFreq;
    private int wordIndex;
    private boolean caseSensitive;

    public FeatureTypeKnownWord(FeatureDictionary wordDict) {
        this(wordDict, false);
    }

    public FeatureTypeKnownWord(FeatureDictionary wordDict, boolean caseSensitive) {
        super(false);
        this.dict = wordDict;
        this.stateNum = this.dict.getStateNum();
        this.idPrefix = "K_";
    }

    private void getNextState() {
        ++this.curState;
        while (this.curState < this.stateNum) {
            if (this.dict.getCount(this.wordIndex, this.curState) == 0) {
                return;
            }
            ++this.curState;
        }
    }

    public boolean startScanFeaturesAt(DataSequence data2, int startPos, int endPos) {
        this.curState = -1;
        if (startPos != endPos) {
            System.out.println("The starting position and the ending position should be the same for word features");
            return false;
        }
        this.wordIndex = data2.getToken(endPos).getIndex();
        if (this.wordIndex < 0) {
            String token2 = data2.getToken(endPos).getContent();
            if (!this.caseSensitive) {
                token2 = token2.toLowerCase();
            }
            this.wordIndex = this.dict.getIndex(token2);
        }
        if (this.wordIndex < 0) {
            return false;
        }
        if (this.dict.getCount(this.wordIndex) <= FeatureTypeWord.RARE_THRESHOLD + 1) {
            return false;
        }
        this.getNextState();
        this.wordFreq = Math.log((double)this.dict.getCount(this.wordIndex) / (double)this.dict.getTotalCount());
        return true;
    }

    public boolean hasNext() {
        return this.curState < this.stateNum && this.curState >= 0;
    }

    public Feature next() {
        FeatureIdentifier id = new FeatureIdentifier(this.idPrefix, this.curState, this.curState);
        BasicFeature f2 = new BasicFeature(id, this.curState, this.wordFreq);
        this.getNextState();
        return f2;
    }
}

