/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.feature.FeatureIdentifier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FeatureMap {
    private Hashtable strToInt = new Hashtable();
    private String[] idToName;
    private boolean frozen = false;

    public boolean isFrozen() {
        return this.frozen;
    }

    public int getId(FeatureIdentifier key) {
        Integer id = (Integer)this.strToInt.get(key);
        if (id != null) {
            return id;
        }
        return -1;
    }

    public int add(FeatureIdentifier id) {
        if (this.frozen) {
            return -1;
        }
        int newId = this.strToInt.size();
        this.strToInt.put(id.copy(), new Integer(newId));
        return newId;
    }

    public void freezeFeatures() {
        this.idToName = new String[this.strToInt.size()];
        Enumeration e = this.strToInt.keys();
        while (e.hasMoreElements()) {
            FeatureIdentifier key = (FeatureIdentifier)e.nextElement();
            this.idToName[this.getId((FeatureIdentifier)key)] = key.toString();
        }
        this.frozen = true;
    }

    public int getFeatureNum() {
        return this.strToInt.size();
    }

    public void write(PrintWriter out) throws IOException {
        out.println(this.strToInt.size());
        Enumeration e = this.strToInt.keys();
        while (e.hasMoreElements()) {
            FeatureIdentifier key = (FeatureIdentifier)e.nextElement();
            out.println(key.toString() + " " + (Integer)this.strToInt.get(key));
        }
    }

    /*
     * WARNING - void declaration
     */
    public int read(BufferedReader in) throws IOException {
        String line;
        int len = Integer.parseInt(in.readLine());
        int l = 0;
        while (l < len && (line = in.readLine()) != null) {
            void var4_6;
            StringTokenizer entry = new StringTokenizer((String)var4_6, " ");
            FeatureIdentifier key = new FeatureIdentifier(entry.nextToken());
            int pos = Integer.parseInt(entry.nextToken());
            this.strToInt.put(key, new Integer(pos));
            ++l;
        }
        this.freezeFeatures();
        return this.strToInt.size();
    }

    public String getIdentifier(int id) {
        return this.idToName[id];
    }

    public String getName(int id) {
        return this.idToName[id];
    }
}

