/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.feature.AbstractFeatureDictionary;
import dragon.ml.seqmodel.feature.FeatureDictionary;
import dragon.util.MathUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class FeatureDictionaryChar
extends AbstractFeatureDictionary
implements FeatureDictionary {
    private SortedArray dictionary;

    public FeatureDictionaryChar(int stateNum, int capacity) {
        super(stateNum);
        this.dictionary = new SortedArray(capacity);
        this.finalized = false;
    }

    public int getIndex(Object feature) {
        int pos = this.dictionary.binarySearch(new HEntry((String)feature, -1));
        if (pos < 0) {
            return -1;
        }
        return ((HEntry)this.dictionary.get(pos)).getIndex();
    }

    public int getStateNum() {
        return this.stateNum;
    }

    public boolean contain(Object feature) {
        return this.dictionary.contains(feature);
    }

    public int size() {
        return this.dictionary.size();
    }

    public int addFeature(Object feature, int label) {
        if (label < 0 || this.finalized) {
            return -1;
        }
        HEntry index = new HEntry((String)feature, this.dictionary.size(), this.stateNum);
        if (!this.dictionary.add(index)) {
            index = (HEntry)this.dictionary.get(this.dictionary.insertedPos());
        }
        index.addFrequency(label, 1);
        return index.getIndex();
    }

    public void finalize() {
        this.cntsOverAllFeature = new int[this.stateNum];
        this.cntsArray = new int[this.dictionary.size()][];
        this.cntsOverAllState = new int[this.dictionary.size()];
        int i = 0;
        while (i < this.dictionary.size()) {
            HEntry entry = (HEntry)this.dictionary.get(i);
            this.cntsArray[((HEntry)entry).index] = entry.stateArray;
            this.cntsOverAllState[((HEntry)entry).index] = MathUtil.sumArray(entry.stateArray);
            ++i;
        }
        i = 0;
        while (i < this.stateNum) {
            this.cntsOverAllFeature[i] = 0;
            int m = 0;
            while (m < this.cntsArray.length) {
                int n = i;
                this.cntsOverAllFeature[n] = this.cntsOverAllFeature[n] + this.cntsArray[m][i];
                ++m;
            }
            this.allTotal += this.cntsOverAllFeature[i];
            ++i;
        }
        this.finalized = true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean read(String filename) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(new File(filename)));
            int dictLen = Integer.parseInt(in.readLine());
            this.cntsOverAllFeature = new int[this.stateNum];
            this.cntsArray = new int[dictLen][this.stateNum];
            this.cntsOverAllState = new int[dictLen];
            int l = 0;
            while (l < dictLen && (line = in.readLine()) != null) {
                void var6_8;
                StringTokenizer entry = new StringTokenizer((String)var6_8, " ");
                String key = entry.nextToken();
                int pos = Integer.parseInt(entry.nextToken());
                HEntry hEntry = new HEntry(key, pos);
                this.dictionary.add(hEntry);
                while (entry.hasMoreTokens()) {
                    int cnt;
                    StringTokenizer scp = new StringTokenizer(entry.nextToken(), ":");
                    int state = Integer.parseInt(scp.nextToken());
                    this.cntsArray[pos][state] = cnt = Integer.parseInt(scp.nextToken());
                }
                this.cntsOverAllState[pos] = MathUtil.sumArray(this.cntsArray[pos]);
                ++l;
            }
            int i = 0;
            while (i < this.stateNum) {
                this.cntsOverAllFeature[i] = 0;
                int m = 0;
                while (m < this.cntsArray.length) {
                    int n = i;
                    this.cntsOverAllFeature[n] = this.cntsOverAllFeature[n] + this.cntsArray[m][i];
                    ++m;
                }
                this.allTotal += this.cntsOverAllFeature[i];
                ++i;
            }
            this.finalized = true;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean write(String filename) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(new File(filename)));
            out.println(this.dictionary.size());
            int i = 0;
            while (i < this.dictionary.size()) {
                HEntry entry = (HEntry)this.dictionary.get(i);
                String key = entry.getFeature();
                int pos = entry.getIndex();
                out.print(key + " " + pos);
                int s = this.getNextStateWithFeature(pos, -1);
                while (s != -1) {
                    out.print(" " + s + ":" + this.cntsArray[pos][s]);
                    s = this.getNextStateWithFeature(pos, s);
                }
                out.println("");
                ++i;
            }
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private class HEntry
    implements Comparable {
        private String feature;
        private int index;
        private int[] stateArray;

        public HEntry(String feature, int v) {
            this.feature = feature;
            this.index = v;
            this.stateArray = null;
        }

        public HEntry(String feature, int v, int numStates) {
            this.feature = feature;
            this.index = v;
            this.stateArray = new int[numStates];
        }

        public void addFrequency(int state, int inc) {
            int n = state;
            this.stateArray[n] = this.stateArray[n] + inc;
        }

        public int getIndex() {
            return this.index;
        }

        public String getFeature() {
            return this.feature;
        }

        public int compareTo(Object o) {
            return this.feature.compareTo(((HEntry)o).getFeature());
        }
    }
}

