/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureIdentifier;

public class BasicFeature
implements Feature {
    private FeatureIdentifier id;
    private int index;
    private int ystart;
    private int yend;
    private double val;

    public BasicFeature() {
        this.index = -1;
        this.ystart = -1;
        this.yend = -1;
        this.id = null;
    }

    public BasicFeature(String id, int label, double val) {
        this(id, -1, label, val);
    }

    public BasicFeature(FeatureIdentifier id, int label, double val) {
        this(id, -1, label, val);
    }

    public BasicFeature(String id, int prevLabel, int label, double val) {
        this(new FeatureIdentifier(id), prevLabel, label, val);
    }

    public BasicFeature(FeatureIdentifier id, int prevLabel, int label, double val) {
        this.id = id;
        this.yend = label;
        this.val = val;
        this.ystart = prevLabel;
        this.index = -1;
    }

    public BasicFeature(BasicFeature f2) {
        this.copyFrom(f2);
    }

    public void copyFrom(BasicFeature f2) {
        this.index = f2.getIndex();
        this.ystart = f2.getPrevLabel();
        this.yend = f2.getLabel();
        this.val = f2.getValue();
        this.id = f2.getID().copy();
    }

    public Feature copy() {
        return new BasicFeature(this);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getLabel() {
        return this.yend;
    }

    public void setLabel(int label) {
        this.yend = label;
    }

    public int getPrevLabel() {
        return this.ystart;
    }

    public void setPrevLabel(int prevLabel) {
        this.ystart = prevLabel;
    }

    public double getValue() {
        return this.val;
    }

    public void setValue(double val) {
        this.val = val;
    }

    public String toString() {
        return this.id + " " + this.val;
    }

    public FeatureIdentifier getID() {
        return this.id;
    }

    public void setID(FeatureIdentifier id) {
        this.id = id;
    }
}

