/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

public abstract class AbstractFeatureDictionary {
    protected int stateNum;
    protected int[][] cntsArray;
    protected int[] cntsOverAllState;
    protected int[] cntsOverAllFeature;
    protected int allTotal;
    protected boolean finalized;

    public abstract int getIndex(Object var1);

    public AbstractFeatureDictionary(int stateNum) {
        this.stateNum = stateNum;
    }

    public int getStateNum() {
        return this.stateNum;
    }

    public int getCount(Object feature) {
        int index = this.getIndex(feature);
        return index >= 0 ? this.cntsOverAllState[index] : 0;
    }

    public int getCount(int featureIndex, int label) {
        return this.cntsArray[featureIndex][label];
    }

    public int getCount(int featureIndex) {
        return this.cntsOverAllState[featureIndex];
    }

    public int getStateCount(int state) {
        return this.cntsOverAllFeature[state];
    }

    public int getTotalCount() {
        return this.allTotal;
    }

    public int getNextStateWithFeature(int index, int prevLabel) {
        int k = prevLabel >= 0 ? prevLabel + 1 : 0;
        while (k < this.cntsArray[index].length) {
            if (this.cntsArray[index][k] > 0) {
                return k;
            }
            ++k;
        }
        return -1;
    }
}

