/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.evaluate;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.data.Dataset;
import dragon.ml.seqmodel.evaluate.AbstractEvaluator;

public class TokenEvaluator
extends AbstractEvaluator {
    private int labelNum;
    private int[] truePos;
    private int[] totalMarkedPos;
    private int[] totalPos;
    private int[][] confuseMatrix;

    public TokenEvaluator(int labelNum) {
        this.labelNum = labelNum;
        this.truePos = new int[labelNum];
        this.totalMarkedPos = new int[labelNum];
        this.totalPos = new int[labelNum];
        this.confuseMatrix = new int[labelNum][labelNum];
    }

    public void evaluate(Dataset human, Dataset machine) {
        int i;
        if (machine.size() != human.size()) {
            System.out.println("Length Mismatch - Auto: " + machine.size() + " Man: " + human.size());
            return;
        }
        human.startScan();
        machine.startScan();
        while (human.hasNext() && machine.hasNext()) {
            DataSequence humanSeq = human.next();
            DataSequence machineSeq = machine.next();
            if (humanSeq.length() != machineSeq.length()) {
                System.out.println("Length Mismatch - Manual: " + humanSeq.length() + " Auto: " + machineSeq.length());
                continue;
            }
            int len = humanSeq.length();
            i = 0;
            while (i < len) {
                int machineLabel = machineSeq.getOriginalLabel(i);
                ++this.totalLabels;
                if (machineLabel >= 0) {
                    int humanLabel = humanSeq.getOriginalLabel(i);
                    int n = machineLabel;
                    this.totalMarkedPos[n] = this.totalMarkedPos[n] + 1;
                    ++this.annotatedLabels;
                    int n2 = humanLabel;
                    this.totalPos[n2] = this.totalPos[n2] + 1;
                    int[] nArray = this.confuseMatrix[humanLabel];
                    int n3 = machineLabel;
                    nArray[n3] = nArray[n3] + 1;
                    if (humanLabel == machineLabel) {
                        ++this.correctAnnotatedLabels;
                        int n4 = humanLabel;
                        this.truePos[n4] = this.truePos[n4] + 1;
                    }
                }
                ++i;
            }
        }
        System.out.println("\n\nCalculations:");
        System.out.println();
        System.out.println("Label\tTrue+\tMarked+\tActual+\tPrec.\tRecall\tF1");
        i = 0;
        while (i < this.labelNum) {
            double prec = this.totalMarkedPos[i] == 0 ? 0.0 : (double)(this.truePos[i] * 100000 / this.totalMarkedPos[i]) / 1000.0;
            double recall2 = this.totalPos[i] == 0 ? 0.0 : (double)(this.truePos[i] * 100000 / this.totalPos[i]) / 1000.0;
            System.out.println(i + ":\t" + this.truePos[i] + "\t" + this.totalMarkedPos[i] + "\t" + this.totalPos[i] + "\t" + prec + "\t" + recall2 + "\t" + 2.0 * prec * recall2 / (prec + recall2));
            ++i;
        }
        System.out.println("---------------------------------------------------------");
        System.out.println("Ov:\t" + this.correctAnnotatedLabels + "\t" + this.annotatedLabels + "\t" + this.totalLabels + "\t" + this.precision() + "\t" + this.recall() + "\t" + 2.0 * this.precision() * this.recall() / (this.precision() + this.recall()));
    }
}

