/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.data;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.data.Dataset;
import java.util.Vector;

public class BasicDataset
implements Dataset {
    private Vector vector = new Vector();
    private int originalLabelNum;
    private int labelNum;
    private int markovOrder;
    private int curPos;

    public BasicDataset(int originalLabelNum, int markovOrder) {
        this.originalLabelNum = originalLabelNum;
        this.markovOrder = markovOrder;
        this.labelNum = 1;
        int i = 0;
        while (i < markovOrder) {
            this.labelNum *= originalLabelNum;
            ++i;
        }
    }

    public Dataset copy() {
        BasicDataset dataset = new BasicDataset(this.originalLabelNum, this.markovOrder);
        this.startScan();
        while (this.hasNext()) {
            dataset.add(this.next().copy());
        }
        return dataset;
    }

    public int size() {
        return this.vector.size();
    }

    public void startScan() {
        this.curPos = 0;
    }

    public boolean hasNext() {
        return this.curPos < this.vector.size();
    }

    public DataSequence next() {
        ++this.curPos;
        return (DataSequence)this.vector.get(this.curPos - 1);
    }

    public boolean add(DataSequence seq2) {
        seq2.setParent(this);
        this.vector.add(seq2);
        return true;
    }

    public int getLabelNum() {
        return this.labelNum;
    }

    public int getOriginalLabelNum() {
        return this.originalLabelNum;
    }

    public int getMarkovOrder() {
        return this.markovOrder;
    }
}

