/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.data;

import dragon.ml.seqmodel.data.BasicToken;
import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.data.Dataset;
import java.util.Vector;

public class BasicDataSequence
implements DataSequence {
    private Vector vector;
    private Dataset parent = null;

    public BasicDataSequence() {
        this(50);
    }

    public BasicDataSequence(int length) {
        this.vector = new Vector(length, 50);
    }

    public DataSequence copy() {
        int len = this.length();
        BasicDataSequence seq2 = new BasicDataSequence(this.length());
        int i = 0;
        while (i < len) {
            seq2.add(this.getToken(i).copy());
            ++i;
        }
        return seq2;
    }

    public Dataset getParent() {
        return this.parent;
    }

    public void setParent(Dataset parent) {
        this.parent = parent;
    }

    public int length() {
        return this.vector.size();
    }

    public int getLabel(int pos) {
        int markovOrder = this.parent.getMarkovOrder();
        if (markovOrder <= 1) {
            BasicToken token2 = (BasicToken)this.vector.get(pos);
            return token2.getLabel();
        }
        if (pos >= markovOrder - 1) {
            int label = 0;
            int i = pos + 1 - markovOrder;
            while (i <= pos) {
                BasicToken token2 = (BasicToken)this.vector.get(i);
                label = label * this.parent.getOriginalLabelNum() + token2.getLabel();
                ++i;
            }
            return label;
        }
        return -1;
    }

    public int getOriginalLabel(int pos) {
        return ((BasicToken)this.vector.get(pos)).getLabel();
    }

    public BasicToken getToken(int pos) {
        return (BasicToken)this.vector.get(pos);
    }

    public void setLabel(int pos, int label) {
        BasicToken token2 = (BasicToken)this.vector.get(pos);
        int markovOrder = this.parent.getMarkovOrder();
        if (markovOrder > 1) {
            token2.setLabel(label % this.parent.getOriginalLabelNum());
            if (pos == markovOrder - 1) {
                label /= this.parent.getOriginalLabelNum();
                while (pos > 0) {
                    token2 = (BasicToken)this.vector.get(--pos);
                    token2.setLabel((label /= this.parent.getOriginalLabelNum()) % this.parent.getOriginalLabelNum());
                }
            }
        } else {
            token2.setLabel(label);
        }
    }

    public void add(BasicToken token2) {
        this.vector.add(token2);
    }

    public int getSegmentEnd(int segmentStart) {
        int len = this.length();
        int curPos = segmentStart + 1;
        while (curPos < len) {
            if (this.getToken(curPos).isSegmentStart()) break;
            ++curPos;
        }
        return curPos - 1;
    }

    public void setSegment(int segmentStart, int segmentEnd, int label) {
        if (this.parent.getMarkovOrder() > 1) {
            System.out.println("Only first-order markov allowed for segment sequencing!");
            return;
        }
        BasicToken curToken = this.getToken(segmentStart);
        curToken.setSegmentMarker(true);
        curToken.setLabel(label);
        int i = segmentStart + 1;
        while (i <= segmentEnd) {
            curToken = this.getToken(i);
            curToken.setSegmentMarker(false);
            curToken.setLabel(label);
            ++i;
        }
        if (segmentEnd < this.length() - 1) {
            this.getToken(segmentEnd + 1).setSegmentMarker(true);
        }
    }
}

