/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix.vector;

import dragon.matrix.DenseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.matrix.vector.DoubleVector;
import java.io.Serializable;
import java.util.Date;

public class PowerMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double tolerance;
    private double dampingFactor;
    private boolean showMessage;
    private int maxIteration;

    public PowerMethod(double tolerance, double dampingFactor) {
        this.tolerance = tolerance;
        this.dampingFactor = dampingFactor;
        this.showMessage = true;
        this.maxIteration = 50;
    }

    public void setMaxIteration(int iteration) {
        this.maxIteration = iteration;
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public DoubleVector getEigenVector(SparseMatrix matrix) {
        int j;
        int len;
        DoubleVector oldVector = new DoubleVector(Math.max(matrix.rows(), matrix.columns()));
        DoubleVector newVector = new DoubleVector(oldVector.size());
        oldVector.assign(1.0 / (double)oldVector.size());
        double[] arrRate = new double[matrix.rows()];
        int i = 0;
        while (i < matrix.rows()) {
            arrRate[i] = 0.0;
            len = matrix.getNonZeroNumInRow(i);
            j = 0;
            while (j < len) {
                int n = i;
                arrRate[n] = arrRate[n] + matrix.getNonZeroDoubleScoreInRow(i, j);
                ++j;
            }
            arrRate[i] = (1.0 - this.dampingFactor) / arrRate[i];
            ++i;
        }
        double constFactor = this.dampingFactor / (double)matrix.rows();
        int k = 0;
        while (k < this.maxIteration) {
            if (this.showMessage) {
                System.out.println(new Date() + " iteration " + k);
            }
            ++k;
            newVector.assign(0.0);
            i = 0;
            while (i < matrix.rows()) {
                len = matrix.getNonZeroNumInRow(i);
                j = 0;
                while (j < len) {
                    double d = arrRate[i] * matrix.getNonZeroDoubleScoreInRow(i, j) + constFactor;
                    int index = matrix.getNonZeroColumnInRow(i, j);
                    newVector.set(index, newVector.get(index) + d * oldVector.get(i));
                    ++j;
                }
                ++i;
            }
            double distance = newVector.distance(oldVector);
            System.out.println(distance);
            if (distance < this.tolerance) break;
            oldVector.assign(newVector);
        }
        return newVector;
    }

    public DoubleVector getEigenVector(DenseMatrix matrix) {
        int j;
        if (matrix.rows() != matrix.columns()) {
            return null;
        }
        DoubleVector oldVector = new DoubleVector(matrix.rows());
        DoubleVector newVector = new DoubleVector(matrix.rows());
        oldVector.assign(1.0 / (double)matrix.rows());
        double[] arrRate = new double[matrix.rows()];
        int i = 0;
        while (i < matrix.rows()) {
            arrRate[i] = 0.0;
            j = 0;
            while (j < matrix.rows()) {
                int n = i;
                arrRate[n] = arrRate[n] + matrix.getDouble(i, j);
                ++j;
            }
            arrRate[i] = (1.0 - this.dampingFactor) / arrRate[i];
            ++i;
        }
        double constFactor = this.dampingFactor / (double)matrix.rows();
        int k = 0;
        while (k < this.maxIteration) {
            if (this.showMessage) {
                System.out.println(new Date() + " iteration " + k);
            }
            ++k;
            newVector.assign(0.0);
            i = 0;
            while (i < matrix.rows()) {
                j = 0;
                while (j < matrix.rows()) {
                    double d = arrRate[i] * matrix.getDouble(i, j) + constFactor;
                    newVector.set(j, newVector.get(j) + d * oldVector.get(i));
                    ++j;
                }
                ++i;
            }
            if (newVector.distance(oldVector) < this.tolerance) break;
            oldVector.assign(newVector);
        }
        return newVector;
    }

    public void setMessageOption(boolean option) {
        this.showMessage = option;
    }
}

