/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix.factorize;

import dragon.matrix.DoubleDenseMatrix;
import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.matrix.IntSuperSparseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.matrix.factorize.AbstractFactorization;
import java.io.Serializable;
import java.util.Date;

public class SVD
extends AbstractFactorization
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[][] U;
    private double[][] V;
    private double[] s;
    private int m;
    private int n;
    private int dimension;

    public static void main(String[] args) {
        IntSuperSparseMatrix matrix = new IntSuperSparseMatrix("xu/query1/relationcpt/all/termdoc.matrix");
        matrix.finalizeData();
        SVD svd = new SVD();
        svd.factorize(matrix, 12);
        DoubleDenseMatrix left = svd.getLeftMatrix();
        DoubleDenseMatrix middle = svd.getMiddleMatrix();
        int i = 0;
        while (i < left.rows()) {
            int j = 0;
            while (j < middle.columns()) {
                left.setDouble(i, j, left.getDouble(i, j) * middle.getDouble(j, j));
                ++j;
            }
            ++i;
        }
        double[] arrSingularValue = svd.getSingularValues();
        i = 0;
        while (i < arrSingularValue.length) {
            System.out.println(arrSingularValue[i]);
            ++i;
        }
    }

    public void factorize(SparseMatrix matrix, int dimension) {
        int i;
        int i2;
        int j;
        int i3;
        int i4;
        int i5;
        this.m = matrix.rows();
        this.n = matrix.columns();
        this.dimension = dimension;
        double[][] A = new double[this.m][this.n];
        int r = 0;
        while (r < this.m) {
            int[] indexList = matrix.getNonZeroColumnsInRow(r);
            double[] scoreList = matrix.getNonZeroDoubleScoresInRow(r);
            int v = 0;
            while (v < indexList.length) {
                A[r][indexList[v]] = scoreList[v];
                ++v;
            }
            ++r;
        }
        int nu = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][nu];
        this.V = new double[this.n][this.n];
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        int k = 0;
        while (k < Math.max(nct, nrt)) {
            System.out.println(new Date() + " processing " + k);
            if (k < nct) {
                this.s[k] = 0.0;
                int i6 = k;
                while (i6 < this.m) {
                    this.s[k] = this.hypot(this.s[k], A[i6][k]);
                    ++i6;
                }
                if (this.s[k] != 0.0) {
                    if (A[k][k] < 0.0) {
                        this.s[k] = -this.s[k];
                    }
                    int i7 = k;
                    while (i7 < this.m) {
                        double[] dArray = A[i7];
                        int n = k;
                        dArray[n] = dArray[n] / this.s[k];
                        ++i7;
                    }
                    double[] dArray = A[k];
                    int n = k;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.s[k] = -this.s[k];
            }
            int j2 = k + 1;
            while (j2 < this.n) {
                if (k < nct & this.s[k] != 0.0) {
                    double t = 0.0;
                    i5 = k;
                    while (i5 < this.m) {
                        t += A[i5][k] * A[i5][j2];
                        ++i5;
                    }
                    t = -t / A[k][k];
                    i4 = k;
                    while (i4 < this.m) {
                        double[] dArray = A[i4];
                        int n = j2;
                        dArray[n] = dArray[n] + t * A[i4][k];
                        ++i4;
                    }
                }
                e[j2] = A[k][j2];
                ++j2;
            }
            if (wantu & k < nct) {
                int i8 = k;
                while (i8 < this.m) {
                    this.U[i8][k] = A[i8][k];
                    ++i8;
                }
            }
            if (k < nrt) {
                e[k] = 0.0;
                int i9 = k + 1;
                while (i9 < this.n) {
                    e[k] = this.hypot(e[k], e[i9]);
                    ++i9;
                }
                if (e[k] != 0.0) {
                    if (e[k + 1] < 0.0) {
                        e[k] = -e[k];
                    }
                    i3 = k + 1;
                    while (i3 < this.n) {
                        int n = i3++;
                        e[n] = e[n] / e[k];
                    }
                    int n = k + 1;
                    e[n] = e[n] + 1.0;
                }
                e[k] = -e[k];
                if (k + 1 < this.m & e[k] != 0.0) {
                    i3 = k + 1;
                    while (i3 < this.m) {
                        work[i3] = 0.0;
                        ++i3;
                    }
                    j = k + 1;
                    while (j < this.n) {
                        i4 = k + 1;
                        while (i4 < this.m) {
                            int n = i4;
                            work[n] = work[n] + e[j] * A[i4][j];
                            ++i4;
                        }
                        ++j;
                    }
                    int j3 = k + 1;
                    while (j3 < this.n) {
                        double t = -e[j3] / e[k + 1];
                        i2 = k + 1;
                        while (i2 < this.m) {
                            double[] dArray = A[i2];
                            int n = j3;
                            dArray[n] = dArray[n] + t * work[i2];
                            ++i2;
                        }
                        ++j3;
                    }
                }
                if (wantv) {
                    i3 = k + 1;
                    while (i3 < this.n) {
                        this.V[i3][k] = e[i3];
                        ++i3;
                    }
                }
            }
            ++k;
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        if (wantu) {
            int j4 = nct;
            while (j4 < nu) {
                i3 = 0;
                while (i3 < this.m) {
                    this.U[i3][j4] = 0.0;
                    ++i3;
                }
                this.U[j4][j4] = 1.0;
                ++j4;
            }
            int k2 = nct - 1;
            while (k2 >= 0) {
                if (this.s[k2] != 0.0) {
                    j = k2 + 1;
                    while (j < nu) {
                        double t = 0.0;
                        i = k2;
                        while (i < this.m) {
                            t += this.U[i][k2] * this.U[i][j];
                            ++i;
                        }
                        t = -t / this.U[k2][k2];
                        i2 = k2;
                        while (i2 < this.m) {
                            double[] dArray = this.U[i2];
                            int n = j;
                            dArray[n] = dArray[n] + t * this.U[i2][k2];
                            ++i2;
                        }
                        ++j;
                    }
                    i4 = k2;
                    while (i4 < this.m) {
                        this.U[i4][k2] = -this.U[i4][k2];
                        ++i4;
                    }
                    this.U[k2][k2] = 1.0 + this.U[k2][k2];
                    int i10 = 0;
                    while (i10 < k2 - 1) {
                        this.U[i10][k2] = 0.0;
                        ++i10;
                    }
                } else {
                    i5 = 0;
                    while (i5 < this.m) {
                        this.U[i5][k2] = 0.0;
                        ++i5;
                    }
                    this.U[k2][k2] = 1.0;
                }
                --k2;
            }
        }
        if (wantv) {
            int k3 = this.n - 1;
            while (k3 >= 0) {
                if (k3 < nrt & e[k3] != 0.0) {
                    int j5 = k3 + 1;
                    while (j5 < nu) {
                        double t = 0.0;
                        int i11 = k3 + 1;
                        while (i11 < this.n) {
                            t += this.V[i11][k3] * this.V[i11][j5];
                            ++i11;
                        }
                        t = -t / this.V[k3 + 1][k3];
                        i = k3 + 1;
                        while (i < this.n) {
                            double[] dArray = this.V[i];
                            int n = j5;
                            dArray[n] = dArray[n] + t * this.V[i][k3];
                            ++i;
                        }
                        ++j5;
                    }
                }
                i3 = 0;
                while (i3 < this.n) {
                    this.V[i3][k3] = 0.0;
                    ++i3;
                }
                this.V[k3][k3] = 1.0;
                --k3;
            }
        }
        int pp = p - 1;
        int iter2 = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block37: while (p > 0) {
            int kase;
            int k4 = p - 2;
            while (k4 >= -1) {
                if (k4 == -1) break;
                if (Math.abs(e[k4]) <= tiny + eps * (Math.abs(this.s[k4]) + Math.abs(this.s[k4 + 1]))) {
                    e[k4] = 0.0;
                    break;
                }
                --k4;
            }
            if (k4 == p - 2) {
                kase = 4;
            } else {
                int ks = p - 1;
                while (ks >= k4) {
                    if (ks == k4) break;
                    double t = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k4 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (Math.abs(this.s[ks]) <= tiny + eps * t) {
                        this.s[ks] = 0.0;
                        break;
                    }
                    --ks;
                }
                if (ks == k4) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k4 = ks;
                }
            }
            ++k4;
            switch (kase) {
                case 1: {
                    int i12;
                    double sn;
                    double cs;
                    double t;
                    double f2 = e[p - 2];
                    e[p - 2] = 0.0;
                    int j6 = p - 2;
                    while (j6 >= k4) {
                        t = this.hypot(this.s[j6], f2);
                        cs = this.s[j6] / t;
                        sn = f2 / t;
                        this.s[j6] = t;
                        if (j6 != k4) {
                            f2 = -sn * e[j6 - 1];
                            e[j6 - 1] = cs * e[j6 - 1];
                        }
                        if (wantv) {
                            i12 = 0;
                            while (i12 < this.n) {
                                t = cs * this.V[i12][j6] + sn * this.V[i12][p - 1];
                                this.V[i12][p - 1] = -sn * this.V[i12][j6] + cs * this.V[i12][p - 1];
                                this.V[i12][j6] = t;
                                ++i12;
                            }
                        }
                        --j6;
                    }
                    continue block37;
                }
                case 2: {
                    int i12;
                    double sn;
                    double cs;
                    double t;
                    double f3 = e[k4 - 1];
                    e[k4 - 1] = 0.0;
                    int j7 = k4;
                    while (j7 < p) {
                        t = this.hypot(this.s[j7], f3);
                        cs = this.s[j7] / t;
                        sn = f3 / t;
                        this.s[j7] = t;
                        f3 = -sn * e[j7];
                        e[j7] = cs * e[j7];
                        if (wantu) {
                            i12 = 0;
                            while (i12 < this.m) {
                                t = cs * this.U[i12][j7] + sn * this.U[i12][k4 - 1];
                                this.U[i12][k4 - 1] = -sn * this.U[i12][j7] + cs * this.U[i12][k4 - 1];
                                this.U[i12][j7] = t;
                                ++i12;
                            }
                        }
                        ++j7;
                    }
                    continue block37;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.s[k4])), Math.abs(e[k4]));
                    double sp2 = this.s[p - 1] / scale;
                    double spm1 = this.s[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.s[k4] / scale;
                    double ek = e[k4] / scale;
                    double b = ((spm1 + sp2) * (spm1 - sp2) + epm1 * epm1) / 2.0;
                    double c = sp2 * epm1 * (sp2 * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f4 = (sk + sp2) * (sk - sp2) + shift;
                    double g = sk * ek;
                    int j8 = k4;
                    while (j8 < p - 1) {
                        int i13;
                        double t = this.hypot(f4, g);
                        double cs = f4 / t;
                        double sn = g / t;
                        if (j8 != k4) {
                            e[j8 - 1] = t;
                        }
                        f4 = cs * this.s[j8] + sn * e[j8];
                        e[j8] = cs * e[j8] - sn * this.s[j8];
                        g = sn * this.s[j8 + 1];
                        this.s[j8 + 1] = cs * this.s[j8 + 1];
                        if (wantv) {
                            i13 = 0;
                            while (i13 < this.n) {
                                t = cs * this.V[i13][j8] + sn * this.V[i13][j8 + 1];
                                this.V[i13][j8 + 1] = -sn * this.V[i13][j8] + cs * this.V[i13][j8 + 1];
                                this.V[i13][j8] = t;
                                ++i13;
                            }
                        }
                        t = this.hypot(f4, g);
                        cs = f4 / t;
                        sn = g / t;
                        this.s[j8] = t;
                        f4 = cs * e[j8] + sn * this.s[j8 + 1];
                        this.s[j8 + 1] = -sn * e[j8] + cs * this.s[j8 + 1];
                        g = sn * e[j8 + 1];
                        e[j8 + 1] = cs * e[j8 + 1];
                        if (wantu && j8 < this.m - 1) {
                            i13 = 0;
                            while (i13 < this.m) {
                                t = cs * this.U[i13][j8] + sn * this.U[i13][j8 + 1];
                                this.U[i13][j8 + 1] = -sn * this.U[i13][j8] + cs * this.U[i13][j8 + 1];
                                this.U[i13][j8] = t;
                                ++i13;
                            }
                        }
                        ++j8;
                    }
                    e[p - 2] = f4;
                    ++iter2;
                    break;
                }
                case 4: {
                    if (this.s[k4] <= 0.0) {
                        double d = this.s[k4] = this.s[k4] < 0.0 ? -this.s[k4] : 0.0;
                        if (wantv) {
                            int i14 = 0;
                            while (i14 <= pp) {
                                this.V[i14][k4] = -this.V[i14][k4];
                                ++i14;
                            }
                        }
                    }
                    while (k4 < pp) {
                        int i15;
                        if (this.s[k4] >= this.s[k4 + 1]) break;
                        double t = this.s[k4];
                        this.s[k4] = this.s[k4 + 1];
                        this.s[k4 + 1] = t;
                        if (wantv && k4 < this.n - 1) {
                            i15 = 0;
                            while (i15 < this.n) {
                                t = this.V[i15][k4 + 1];
                                this.V[i15][k4 + 1] = this.V[i15][k4];
                                this.V[i15][k4] = t;
                                ++i15;
                            }
                        }
                        if (wantu && k4 < this.m - 1) {
                            i15 = 0;
                            while (i15 < this.m) {
                                t = this.U[i15][k4 + 1];
                                this.U[i15][k4 + 1] = this.U[i15][k4];
                                this.U[i15][k4] = t;
                                ++i15;
                            }
                        }
                        ++k4;
                    }
                    iter2 = 0;
                    --p;
                }
            }
        }
    }

    public DoubleDenseMatrix getLeftMatrix() {
        int rows = this.m;
        int columns = Math.min(this.dimension, this.n);
        double[][] newMatrix = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                newMatrix[i][j] = this.U[i][j];
                ++j;
            }
            ++i;
        }
        DoubleFlatDenseMatrix ddm = new DoubleFlatDenseMatrix(newMatrix);
        return ddm;
    }

    public DoubleDenseMatrix getRightMatrix() {
        int len = Math.min(this.dimension, this.n);
        double[][] newMatrix = new double[len][this.n];
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < this.n) {
                newMatrix[i][j] = this.V[i][j];
                ++j;
            }
            ++i;
        }
        DoubleFlatDenseMatrix ddm = new DoubleFlatDenseMatrix(newMatrix);
        return ddm;
    }

    public double[] getSingularValues() {
        int len = Math.min(this.dimension, this.s.length);
        double[] sv = new double[len];
        int i = 0;
        while (i < len) {
            sv[i] = this.s[i];
            ++i;
        }
        return sv;
    }

    public DoubleDenseMatrix getMiddleMatrix() {
        int len = Math.min(this.dimension, this.s.length);
        DoubleFlatDenseMatrix x2 = new DoubleFlatDenseMatrix(len, len);
        int i = 0;
        while (i < len) {
            x2.setDouble(i, i, this.s[i]);
            ++i;
        }
        return x2;
    }

    private double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }
}

