/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.Cell;
import dragon.matrix.SparseMatrix;
import dragon.util.FastBinaryReader;
import dragon.util.FastBinaryWriter;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;

public class SparseMatrixFactory {
    private String matrixFilename;
    private int rows;
    private int columns;
    private int cells;
    private int cellDataLength;

    public SparseMatrixFactory(String matrixFilename, int cellDataLength) {
        this.matrixFilename = matrixFilename;
        this.cellDataLength = cellDataLength;
        this.readStatInfo(matrixFilename);
    }

    public String getMatrixFilename() {
        return this.matrixFilename;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public int getCellDataLength() {
        return this.cellDataLength;
    }

    public int getNonZeroNum() {
        return this.cells;
    }

    public boolean add(SparseMatrix newMatrix) {
        try {
            int num2;
            int j;
            if (newMatrix == null || newMatrix.getNonZeroNum() == 0) {
                return false;
            }
            File matrixf = new File(this.matrixFilename);
            if (!matrixf.exists()) {
                return this.saveSparseMatrix(newMatrix);
            }
            if (newMatrix.getBaseRow() >= this.rows) {
                return this.append(newMatrix);
            }
            System.out.println(new Date() + " Adding to old matrix...");
            ArrayList<Cell> mergedCellList = new ArrayList<Cell>();
            byte[] cellData = new byte[this.cellDataLength];
            int mergedCellNum = 0;
            String tempMatrixFilename = this.matrixFilename + ".tmp";
            FastBinaryReader fbMatrixOld = new FastBinaryReader(matrixf);
            FastBinaryWriter fbMatrixNew = new FastBinaryWriter(tempMatrixFilename);
            fbMatrixOld.skip(12L);
            fbMatrixNew.writeInt(this.rows > newMatrix.rows() ? this.rows : newMatrix.rows());
            fbMatrixNew.writeInt(this.columns > newMatrix.columns() ? this.columns : newMatrix.columns());
            fbMatrixNew.writeInt(this.cells + newMatrix.getNonZeroNum());
            RandomAccessFile rafMatrixOld = new RandomAccessFile(matrixf, "r");
            long priorBaseRowData = this.getSuperMatrixRowStart(rafMatrixOld, newMatrix.getBaseRow()) - 12L;
            if (priorBaseRowData > 0L) {
                fbMatrixNew.write(fbMatrixOld, priorBaseRowData);
            }
            rafMatrixOld.seek(priorBaseRowData + 12L + 8L);
            int minRows = newMatrix.rows() < this.rows ? newMatrix.rows() : this.rows;
            int i = newMatrix.getBaseRow();
            while (i < minRows) {
                boolean rowAppendMode;
                fbMatrixOld.readInt();
                int oldNum = fbMatrixOld.readInt();
                int newNum = newMatrix.getNonZeroNumInRow(i);
                if (newNum == 0) {
                    rowAppendMode = true;
                    rafMatrixOld.skipBytes(oldNum * (this.cellDataLength + 4) + 8);
                } else if (oldNum == 0) {
                    rowAppendMode = true;
                    rafMatrixOld.skipBytes(8);
                } else {
                    rafMatrixOld.skipBytes((oldNum - 1) * (this.cellDataLength + 4));
                    int lastColumnInRow = rafMatrixOld.readInt();
                    rafMatrixOld.skipBytes(this.cellDataLength + 8);
                    rowAppendMode = lastColumnInRow < newMatrix.getNonZeroColumnInRow(i, 0);
                }
                if (rowAppendMode) {
                    fbMatrixNew.writeInt(i);
                    fbMatrixNew.writeInt(newNum + oldNum);
                    fbMatrixNew.write(fbMatrixOld, (long)(oldNum * (newMatrix.getCellDataLength() + 4)));
                    j = 0;
                    while (j < newNum) {
                        fbMatrixNew.writeInt(newMatrix.getNonZeroColumnInRow(i, j));
                        fbMatrixNew.write(newMatrix.getNonZeroCellInRow(i, j).toByteArray());
                        ++j;
                    }
                    fbMatrixNew.flush();
                } else {
                    int column;
                    mergedCellList.clear();
                    int oldPos = 0;
                    int newPos = 0;
                    Cell oldCell = null;
                    Cell newCell = null;
                    while (oldPos < oldNum && newPos < newNum) {
                        if (oldCell == null) {
                            column = fbMatrixOld.readInt();
                            fbMatrixOld.read(cellData);
                            oldCell = newMatrix.createCell(i, column, cellData);
                        }
                        if (newCell == null) {
                            newCell = newMatrix.getNonZeroCellInRow(i, newPos);
                        }
                        if (oldCell.getColumn() < newCell.getColumn()) {
                            mergedCellList.add(oldCell);
                            ++oldPos;
                            oldCell = null;
                            continue;
                        }
                        if (oldCell.getColumn() > newCell.getColumn()) {
                            mergedCellList.add(newCell);
                            ++newPos;
                            newCell = null;
                            continue;
                        }
                        oldCell.merge(newCell);
                        mergedCellList.add(oldCell);
                        ++oldPos;
                        ++newPos;
                        oldCell = null;
                        newCell = null;
                        ++mergedCellNum;
                    }
                    if (oldCell != null) {
                        mergedCellList.add(oldCell);
                        ++oldPos;
                    }
                    while (oldPos < oldNum) {
                        column = fbMatrixOld.readInt();
                        fbMatrixOld.read(cellData);
                        oldCell = newMatrix.createCell(i, column, cellData);
                        mergedCellList.add(oldCell);
                        ++oldPos;
                    }
                    while (newPos < newNum) {
                        mergedCellList.add(newMatrix.getNonZeroCellInRow(i, newPos));
                        ++newPos;
                    }
                    num2 = mergedCellList.size();
                    fbMatrixNew.writeInt(i);
                    fbMatrixNew.writeInt(num2);
                    j = 0;
                    while (j < num2) {
                        newCell = (Cell)mergedCellList.get(j);
                        fbMatrixNew.writeInt(newCell.getColumn());
                        fbMatrixNew.write(newCell.toByteArray());
                        ++j;
                    }
                    fbMatrixNew.flush();
                }
                ++i;
            }
            mergedCellList.clear();
            rafMatrixOld.close();
            if (minRows < this.rows) {
                fbMatrixNew.write(fbMatrixOld, fbMatrixOld.remaining());
            }
            fbMatrixOld.close();
            i = minRows;
            while (i < newMatrix.rows()) {
                num2 = newMatrix.getNonZeroNumInRow(i);
                fbMatrixNew.writeInt(i);
                fbMatrixNew.writeInt(num2);
                j = 0;
                while (j < num2) {
                    fbMatrixNew.writeInt(newMatrix.getNonZeroColumnInRow(i, j));
                    fbMatrixNew.write(newMatrix.getNonZeroCellInRow(i, j).toByteArray());
                    ++j;
                }
                fbMatrixNew.flush();
                ++i;
            }
            fbMatrixNew.close();
            this.rows = this.rows > newMatrix.rows() ? this.rows : newMatrix.rows();
            this.columns = this.columns > newMatrix.columns() ? this.columns : newMatrix.columns();
            this.cells = this.cells + newMatrix.getNonZeroNum() - mergedCellNum;
            if (!matrixf.delete()) {
                this.matrixFilename = tempMatrixFilename;
            } else {
                File matrixTemp = new File(tempMatrixFilename);
                matrixTemp.renameTo(matrixf);
            }
            if (mergedCellNum > 0) {
                rafMatrixOld = new RandomAccessFile(this.matrixFilename, "rw");
                rafMatrixOld.skipBytes(8);
                rafMatrixOld.writeInt(this.cells);
                rafMatrixOld.close();
            }
            System.out.println(new Date() + " Finish adding");
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean append(SparseMatrix newMatrix) {
        try {
            if (newMatrix == null || newMatrix.getNonZeroNum() == 0) {
                return false;
            }
            File matrixf = new File(this.matrixFilename);
            if (!matrixf.exists()) {
                return this.saveSparseMatrix(newMatrix);
            }
            System.out.println(new Date() + " Appending to old matrix...");
            RandomAccessFile rafMatrix = new RandomAccessFile(matrixf, "rw");
            rafMatrix.writeInt(newMatrix.rows());
            rafMatrix.writeInt(newMatrix.columns());
            rafMatrix.writeInt(this.cells + newMatrix.getNonZeroNum());
            rafMatrix.close();
            FastBinaryWriter fbMatrix = new FastBinaryWriter(this.matrixFilename, true);
            int i = this.rows;
            while (i < newMatrix.rows()) {
                int num2 = newMatrix.getNonZeroNumInRow(i);
                fbMatrix.writeInt(i);
                fbMatrix.writeInt(num2);
                int j = 0;
                while (j < num2) {
                    fbMatrix.writeInt(newMatrix.getNonZeroColumnInRow(i, j));
                    fbMatrix.write(newMatrix.getNonZeroCellInRow(i, j).toByteArray());
                    ++j;
                }
                fbMatrix.flush();
                ++i;
            }
            fbMatrix.close();
            this.rows = newMatrix.rows();
            this.columns = newMatrix.columns();
            this.cells += newMatrix.getNonZeroNum();
            System.out.println(new Date() + " Finish appending");
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void genIndexFile(String indexFilename) {
        try {
            File file = new File(this.matrixFilename);
            if (!file.exists()) {
                return;
            }
            RandomAccessFile rafMatrix = new RandomAccessFile(file, "r");
            new File(indexFilename).delete();
            FastBinaryWriter fwIndex = new FastBinaryWriter(indexFilename);
            rafMatrix.skipBytes(12);
            fwIndex.writeInt(this.rows);
            fwIndex.writeInt(this.columns);
            fwIndex.writeInt(this.cells);
            int i = 0;
            while (i < this.rows) {
                long rowOffset = rafMatrix.getFilePointer();
                int row = rafMatrix.readInt();
                if (row != i) {
                    System.out.println("error");
                }
                int rowLen = rafMatrix.readInt();
                fwIndex.writeInt(row);
                fwIndex.writeLong(rowOffset);
                fwIndex.writeInt(rowLen);
                rafMatrix.skipBytes(rowLen * (this.cellDataLength + 4));
                fwIndex.flush();
                ++i;
            }
            rafMatrix.close();
            fwIndex.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean saveSparseMatrix(SparseMatrix matrix) {
        System.out.println(new Date() + " Saving Matrix...");
        try {
            FastBinaryWriter rafMatrix = new FastBinaryWriter(this.matrixFilename);
            this.rows = matrix.rows();
            this.columns = matrix.columns();
            this.cells = matrix.getNonZeroNum();
            rafMatrix.writeInt(this.rows);
            rafMatrix.writeInt(this.columns);
            rafMatrix.writeInt(this.cells);
            int i = 0;
            while (i < this.rows) {
                int num2 = matrix.getNonZeroNumInRow(i);
                rafMatrix.writeInt(i);
                rafMatrix.writeInt(num2);
                int j = 0;
                while (j < num2) {
                    rafMatrix.writeInt(matrix.getNonZeroColumnInRow(i, j));
                    rafMatrix.write(matrix.getNonZeroCellInRow(i, j).toByteArray());
                    ++j;
                }
                rafMatrix.flush();
                ++i;
            }
            rafMatrix.close();
            System.out.println(new Date() + " Finish saving");
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void readStatInfo(String matrixFile) {
        File matrixf = new File(this.matrixFilename);
        if (!matrixf.exists()) {
            this.rows = 0;
            this.columns = 0;
            this.cells = 0;
            return;
        }
        try {
            FastBinaryReader rafMatrix = new FastBinaryReader(matrixFile);
            this.rows = rafMatrix.readInt();
            this.columns = rafMatrix.readInt();
            this.cells = rafMatrix.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long getSuperMatrixRowStart(RandomAccessFile raf, int row) {
        try {
            raf.seek(12L);
            while (raf.readInt() < row) {
                int len = raf.readInt();
                raf.skipBytes(len * (this.cellDataLength + 4));
            }
            return raf.getFilePointer() - 4L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }
}

