/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractFlatSparseMatrix;
import dragon.matrix.Cell;
import dragon.matrix.IntCell;
import dragon.matrix.IntSparseMatrix;
import dragon.matrix.SparseMatrix;
import java.io.Serializable;

public class IntFlatSparseMatrix
extends AbstractFlatSparseMatrix
implements IntSparseMatrix,
Serializable {
    private static final long serialVersionUID = 1L;

    public IntFlatSparseMatrix() {
        super(false, false, IntCell.getCellDataLength());
    }

    public IntFlatSparseMatrix(boolean mergeMode, boolean miniMode) {
        super(mergeMode, miniMode, IntCell.getCellDataLength());
    }

    public IntFlatSparseMatrix(String filename) {
        super(false, false, IntCell.getCellDataLength());
        this.readTextMatrixFile(filename);
    }

    public IntFlatSparseMatrix(String filename, boolean binaryFile) {
        super(false, false, IntCell.getCellDataLength());
        if (binaryFile) {
            this.readBinaryMatrixFile(filename);
        } else {
            this.readTextMatrixFile(filename);
        }
    }

    public SparseMatrix createSparseMatrix() {
        return new IntFlatSparseMatrix();
    }

    public Cell createCell(int row, int column, byte[] data2) {
        IntCell cur = new IntCell(row, column);
        cur.fromByteArray(data2);
        return cur;
    }

    public Cell createCell(int row, int column, String data2) {
        IntCell cur = new IntCell(row, column);
        cur.fromString(data2);
        return cur;
    }

    public boolean add(int row, int column, int score) {
        return this.add(new IntCell(row, column, score));
    }

    public long getRowSum(int row) {
        long sum2 = 0L;
        int num2 = this.getNonZeroNumInRow(row);
        int count2 = 0;
        while (count2 < num2) {
            sum2 += (long)this.getNonZeroIntScoreInRow(row, count2);
            ++count2;
        }
        return sum2;
    }

    public long getColumnSum(int column) {
        return ((IntFlatSparseMatrix)this.transpose()).getRowSum(column);
    }
}

