/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractCell;
import dragon.matrix.Cell;
import dragon.util.ByteArrayConvert;
import java.io.Serializable;

public class IntCell
extends AbstractCell
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int row;
    protected int col;
    protected int score;

    public IntCell(int row, int column, int score) {
        this.row = row;
        this.col = column;
        this.score = score;
    }

    public IntCell(int row, int column) {
        this.row = row;
        this.col = column;
        this.score = 0;
    }

    public static int getCellDataLength() {
        return 4;
    }

    public void merge(Cell cell) {
        this.score = cell.getResetOption() ? cell.getIntScore() : (this.score += cell.getIntScore());
    }

    public byte[] toByteArray() {
        return ByteArrayConvert.toByte(this.score);
    }

    public void fromByteArray(byte[] data2) {
        this.score = ByteArrayConvert.toInt(data2);
    }

    public String toString() {
        return String.valueOf(this.score);
    }

    public void fromString(String data2) {
        this.score = Integer.parseInt(data2);
    }

    public Cell transpose() {
        return new IntCell(this.col, this.row, this.score);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.col;
    }

    public double getDoubleScore() {
        return this.score;
    }

    public int getIntScore() {
        return this.score;
    }

    public long getLongScore() {
        return this.score;
    }

    public byte getByteScore() {
        return (byte)this.score;
    }

    public void setScore(double score) {
        this.score = (int)score;
    }

    public void setDoubleScore(double score) {
        this.score = (int)score;
    }

    public void setIntScore(int score) {
        this.score = score;
    }

    public void setLongScore(long score) {
        this.score = (int)score;
    }

    public void setByteScore(byte score) {
        this.score = score;
    }
}

