/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractFlatSparseMatrix;
import dragon.matrix.AbstractSuperSparseMatrix;
import dragon.matrix.Cell;
import dragon.matrix.DoubleCell;
import dragon.matrix.DoubleFlatSparseMatrix;
import dragon.matrix.DoubleRow;
import dragon.matrix.DoubleSparseMatrix;
import dragon.matrix.Row;
import dragon.matrix.SparseMatrix;
import dragon.util.FileUtil;

public class DoubleSuperSparseMatrix
extends AbstractSuperSparseMatrix
implements DoubleSparseMatrix {
    private static final long serialVersionUID = 1L;

    public DoubleSuperSparseMatrix(String matrixFile) {
        super(null, matrixFile, DoubleCell.getCellDataLength());
    }

    public DoubleSuperSparseMatrix(String indexFile, String matrixFile) {
        super(indexFile, matrixFile, DoubleCell.getCellDataLength());
    }

    public DoubleSuperSparseMatrix(String matrixFile, boolean mergeMode, boolean miniMode) {
        super(null, matrixFile, DoubleCell.getCellDataLength(), mergeMode, miniMode);
    }

    public DoubleSuperSparseMatrix(String indexFile, String matrixFile, boolean mergeMode, boolean miniMode) {
        super(indexFile, matrixFile, DoubleCell.getCellDataLength(), mergeMode, miniMode);
    }

    public SparseMatrix createSparseMatrix() {
        String indexFile = FileUtil.getNewTempFilename("newmatrix", "index");
        String matrixFile = FileUtil.getNewTempFilename("newmatrix", "matrix");
        return new DoubleSuperSparseMatrix(indexFile, matrixFile, false, false);
    }

    protected AbstractFlatSparseMatrix createFlatSparseMatrix(boolean mergeMode, boolean miniMode) {
        return new DoubleFlatSparseMatrix(mergeMode, miniMode);
    }

    protected Row createRow(int row, int columns, byte[] data2) {
        DoubleRow cur = new DoubleRow();
        cur.load(row, columns, data2);
        return cur;
    }

    public Cell createCell(int row, int column, byte[] data2) {
        DoubleCell cur = new DoubleCell(row, column);
        cur.fromByteArray(data2);
        return cur;
    }

    public Cell createCell(int row, int column, String data2) {
        DoubleCell cur = new DoubleCell(row, column);
        cur.fromString(data2);
        return cur;
    }

    public boolean add(int row, int column, double score) {
        return this.add(new DoubleCell(row, column, score));
    }

    public double getDouble(int row, int column) {
        if (row >= this.rows) {
            return 0.0;
        }
        return ((DoubleRow)this.getRow(row)).getDouble(column);
    }

    public double getNonZeroDoubleScoreInRow(int row, int index) {
        if (row >= this.rows) {
            return 0.0;
        }
        return ((DoubleRow)this.getRow(row)).getNonZeroDoubleScore(index);
    }

    public double[] getNonZeroDoubleScoresInRow(int row) {
        if (row >= this.rows) {
            return null;
        }
        double[] oldArray = ((DoubleRow)this.getRow(row)).getNonZeroDoubleScores();
        double[] newArray = new double[oldArray.length];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public double getRowSum(int row) {
        double sum2 = 0.0;
        double[] scores = this.getNonZeroDoubleScoresInRow(row);
        int count2 = 0;
        while (count2 < scores.length) {
            sum2 += scores[count2];
            ++count2;
        }
        return sum2;
    }

    public double getColumnSum(int column) {
        return ((DoubleSuperSparseMatrix)this.transpose()).getRowSum(column);
    }
}

