/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractDenseMatrix;
import dragon.matrix.DoubleDenseMatrix;
import dragon.util.FastBinaryReader;
import dragon.util.FastBinaryWriter;
import dragon.util.FileUtil;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Serializable;

public class DoubleFlatDenseMatrix
extends AbstractDenseMatrix
implements DoubleDenseMatrix,
Serializable {
    private static final long serialVersionUID = 1L;
    private double[][] arrMatrix;

    public DoubleFlatDenseMatrix(double[][] newMatrix) {
        super(newMatrix.length, newMatrix[0].length, 8);
        this.arrMatrix = newMatrix;
    }

    public DoubleFlatDenseMatrix(int row, int column) {
        super(row, column, 8);
        this.arrMatrix = new double[row][column];
    }

    public DoubleFlatDenseMatrix(String filename) {
        super(-1, -1, 8);
        this.readTextMatrixFile(filename);
    }

    public DoubleFlatDenseMatrix(String filename, boolean binaryFile) {
        super(-1, -1, 8);
        if (binaryFile) {
            this.readBinMatrixFile(filename);
        } else {
            this.readTextMatrixFile(filename);
        }
    }

    public void assign(double val) {
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.columns) {
                this.arrMatrix[i][j] = val;
                ++j;
            }
            ++i;
        }
    }

    public boolean add(int row, int column, double score) {
        if (row > this.rows || column > this.columns) {
            return false;
        }
        double[] dArray = this.arrMatrix[row];
        int n = column;
        dArray[n] = dArray[n] + score;
        return true;
    }

    public boolean setDouble(int row, int column, double score) {
        if (row > this.rows || column > this.columns) {
            return false;
        }
        this.arrMatrix[row][column] = score;
        return true;
    }

    public double getRowSum(int row) {
        double sum2 = 0.0;
        int i = 0;
        while (i < this.columns) {
            sum2 += this.arrMatrix[row][i];
            ++i;
        }
        return sum2;
    }

    public double getColumnSum(int column) {
        double sum2 = 0.0;
        int i = 0;
        while (i < this.rows) {
            sum2 += this.arrMatrix[i][column];
            ++i;
        }
        return sum2;
    }

    public int getInt(int row, int column) {
        return (int)this.arrMatrix[row][column];
    }

    public double getDouble(int row, int column) {
        return this.arrMatrix[row][column];
    }

    public void saveTo(String filename, boolean binary) {
        if (!binary) {
            this.saveTo(filename);
            return;
        }
        FastBinaryWriter fastBinWriter = new FastBinaryWriter(filename);
        try {
            fastBinWriter.writeInt(this.rows);
            fastBinWriter.writeInt(this.columns);
            fastBinWriter.writeInt(this.rows * this.columns);
            int i = 0;
            while (i < this.rows) {
                int j = 0;
                while (j < this.columns) {
                    fastBinWriter.writeDouble(this.arrMatrix[i][j]);
                    ++j;
                }
                if (i % 100 == 0) {
                    fastBinWriter.flush();
                }
                ++i;
            }
            fastBinWriter.flush();
            fastBinWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveTo(String filename) {
        this.print(FileUtil.getPrintWriter(filename));
    }

    public void print(PrintWriter out) {
        try {
            out.write(String.valueOf(this.rows) + "," + String.valueOf(this.columns) + "," + String.valueOf(this.rows * this.columns) + "\n");
            int i = 0;
            while (i < this.rows) {
                int j = 0;
                while (j < this.columns) {
                    out.write(String.valueOf(this.arrMatrix[i][j]) + ",");
                    ++j;
                }
                out.write("\n");
                if (i % 100 == 0) {
                    out.flush();
                }
                ++i;
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readTextMatrixFile(String fileName) {
        BufferedReader br = FileUtil.getTextReader(fileName);
        try {
            String line = br.readLine();
            String[] arrLine = line.split(",");
            this.rows = Integer.parseInt(arrLine[0]);
            this.columns = Integer.parseInt(arrLine[1]);
            this.arrMatrix = new double[this.rows][this.columns];
            int i = 0;
            while ((line = br.readLine()) != null) {
                arrLine = line.split(",");
                int j = 0;
                while (j < this.arrMatrix[0].length) {
                    this.arrMatrix[i][j] = Double.parseDouble(arrLine[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void readBinMatrixFile(String fileName) {
        FastBinaryReader fbr = new FastBinaryReader(fileName);
        try {
            this.rows = fbr.readInt();
            this.columns = fbr.readInt();
            this.arrMatrix = new double[this.rows][this.columns];
            fbr.readInt();
            int i = 0;
            while (i < this.rows) {
                int j = 0;
                while (j < this.columns) {
                    this.arrMatrix[i][j] = fbr.readDouble();
                    ++j;
                }
                ++i;
            }
            fbr.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void close() {
        this.rows = 0;
        this.columns = 0;
        this.arrMatrix = null;
    }
}

