/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractMatrix;
import dragon.matrix.Cell;
import dragon.matrix.DoubleSparseMatrix;
import dragon.matrix.IntSparseMatrix;
import dragon.matrix.Matrix;
import dragon.matrix.SparseMatrix;
import java.io.Serializable;
import java.util.Date;

public abstract class AbstractSparseMatrix
extends AbstractMatrix
implements SparseMatrix,
Serializable {
    protected boolean isFinalized;
    protected boolean mergeMode;
    protected boolean miniMode;

    public AbstractSparseMatrix(boolean mergeMode, boolean miniMode, int cellDataLength) {
        this.mergeMode = mergeMode;
        this.miniMode = miniMode;
        this.cellDataLength = cellDataLength;
        this.transposeMatrix = null;
        this.isFinalized = false;
    }

    public boolean isFinalized() {
        return this.isFinalized;
    }

    public boolean finalizeData() {
        return this.finalizeData(true);
    }

    public Cell getNonZeroCellInColumn(int column, int index) {
        return ((SparseMatrix)this.transpose()).getNonZeroCellInRow(column, index);
    }

    public int getNonZeroNumInColumn(int column) {
        return ((SparseMatrix)this.transpose()).getNonZeroNumInRow(column);
    }

    public int getNonZeroRowInColumn(int column, int index) {
        return ((SparseMatrix)this.transpose()).getNonZeroColumnInRow(column, index);
    }

    public int[] getNonZeroRowsInColumn(int column) {
        return ((SparseMatrix)this.transpose()).getNonZeroColumnsInRow(column);
    }

    public double getDouble(int row, int column) {
        Cell curCell = this.getCell(row, column);
        if (curCell != null) {
            return curCell.getDoubleScore();
        }
        return 0.0;
    }

    public int getInt(int row, int column) {
        Cell curCell = this.getCell(row, column);
        if (curCell != null) {
            return curCell.getIntScore();
        }
        return 0;
    }

    public double getNonZeroDoubleScoreInColumn(int column, int index) {
        return ((SparseMatrix)this.transpose()).getNonZeroDoubleScoreInRow(column, index);
    }

    public double[] getNonZeroDoubleScoresInColumn(int column) {
        return ((SparseMatrix)this.transpose()).getNonZeroDoubleScoresInRow(column);
    }

    public int getNonZeroIntScoreInColumn(int column, int index) {
        return ((SparseMatrix)this.transpose()).getNonZeroIntScoreInRow(column, index);
    }

    public int[] getNonZeroIntScoresInColumn(int column) {
        return ((SparseMatrix)this.transpose()).getNonZeroIntScoresInRow(column);
    }

    public double getNonZeroDoubleScoreInRow(int row, int index) {
        return this.getNonZeroCellInRow(row, index).getDoubleScore();
    }

    public int getNonZeroIntScoreInRow(int row, int index) {
        return this.getNonZeroCellInRow(row, index).getIntScore();
    }

    public double[] getNonZeroDoubleScoresInRow(int row) {
        int num2 = this.getNonZeroNumInRow(row);
        double[] arrScore = new double[num2];
        int count2 = 0;
        while (count2 < num2) {
            arrScore[count2] = this.getNonZeroCellInRow(row, count2).getDoubleScore();
            ++count2;
        }
        return arrScore;
    }

    public int[] getNonZeroIntScoresInRow(int row) {
        int num2 = this.getNonZeroNumInRow(row);
        int[] arrScore = new int[num2];
        int count2 = 0;
        while (count2 < num2) {
            arrScore[count2] = this.getNonZeroCellInRow(row, count2).getIntScore();
            ++count2;
        }
        return arrScore;
    }

    public boolean genCooccurrenceMatrix(IntSparseMatrix outputCooccurMatrix) {
        return this.genCooccurrenceMatrix(this, 1, outputCooccurMatrix);
    }

    public boolean genCooccurrenceMatrix(SparseMatrix matrixY, IntSparseMatrix outputCooccurMatrix) {
        return this.genCooccurrenceMatrix(matrixY, 1, outputCooccurMatrix);
    }

    public boolean genCooccurrenceMatrix(SparseMatrix matrixY, int minOccurrence, IntSparseMatrix outputCooccurMatrix) {
        AbstractSparseMatrix matrixX = this;
        if (matrixX.columns() != matrixY.columns()) {
            return false;
        }
        boolean equal = matrixX.equals(matrixY);
        int i = 0;
        while (i < matrixX.rows()) {
            System.out.println(new Date().toString() + " Processing Row " + i);
            int[] arrColumnX = matrixX.getNonZeroColumnsInRow(i);
            int xNum = matrixX.getNonZeroNumInRow(i);
            int j = equal ? i + 1 : 0;
            while (j < matrixY.rows()) {
                int coOccurCount = 0;
                int x2 = 0;
                int y = 0;
                int[] arrColumnY = matrixY.getNonZeroColumnsInRow(j);
                int yNum = matrixY.getNonZeroNumInRow(j);
                while (x2 < xNum && y < yNum) {
                    if (arrColumnX[x2] < arrColumnY[y]) {
                        ++x2;
                        continue;
                    }
                    if (arrColumnX[x2] == arrColumnY[y]) {
                        ++x2;
                        ++y;
                        ++coOccurCount;
                        continue;
                    }
                    ++y;
                }
                if (coOccurCount >= minOccurrence) {
                    outputCooccurMatrix.add(i, j, coOccurCount);
                    if (equal) {
                        outputCooccurMatrix.add(i, i, xNum);
                        outputCooccurMatrix.add(j, i, coOccurCount);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (equal) {
            outputCooccurMatrix.finalizeData();
        } else {
            outputCooccurMatrix.finalizeData(false);
        }
        return true;
    }

    public int getCooccurrenceCount(int rowA, int rowB) {
        int coOccurCount = 0;
        int x2 = 0;
        int y = 0;
        int xNum = this.getNonZeroNumInRow(rowA);
        int yNum = this.getNonZeroNumInRow(rowB);
        while (x2 < xNum && y < yNum) {
            int yCol;
            int xCol = this.getNonZeroColumnInRow(rowA, x2);
            if (xCol < (yCol = this.getNonZeroColumnInRow(rowB, y))) {
                ++x2;
                continue;
            }
            if (xCol == yCol) {
                ++x2;
                ++y;
                ++coOccurCount;
                continue;
            }
            ++y;
        }
        return coOccurCount;
    }

    public double cosine(int rowA, int rowB) {
        int x2 = 0;
        int y = 0;
        double xy = 0.0;
        double x22 = 0.0;
        double y2 = 0.0;
        int xNum = this.getNonZeroNumInRow(rowA);
        int yNum = this.getNonZeroNumInRow(rowB);
        if (xNum == 0 || yNum == 0) {
            return 0.0;
        }
        double[] arrXScore = this.getNonZeroDoubleScoresInRow(rowA);
        double[] arrYScore = this.getNonZeroDoubleScoresInRow(rowB);
        int[] arrXCol = this.getNonZeroColumnsInRow(rowA);
        int[] arrYCol = this.getNonZeroColumnsInRow(rowB);
        while (x2 < xNum && y < yNum) {
            if (arrXCol[x2] < arrYCol[y]) {
                x22 += arrXScore[x2] * arrXScore[x2];
                ++x2;
                continue;
            }
            if (arrXCol[x2] == arrYCol[y]) {
                xy += arrXScore[x2] * arrYScore[y];
                x22 += arrXScore[x2] * arrXScore[x2];
                y2 += arrYScore[y] * arrYScore[y];
                ++x2;
                ++y;
                continue;
            }
            y2 += arrYScore[y] * arrYScore[y];
            ++y;
        }
        while (y < yNum) {
            y2 += arrYScore[y] * arrYScore[y];
            ++y;
        }
        while (x2 < xNum) {
            x22 += arrXScore[x2] * arrXScore[x2];
            ++x2;
        }
        return xy / (Math.sqrt(x22) * Math.sqrt(y2));
    }

    public static boolean genTranslationMatrix(IntSparseMatrix inputCooccurMatrix, DoubleSparseMatrix outputTransMatrix) {
        int i = 0;
        while (i < inputCooccurMatrix.rows()) {
            int[] arrColumn = inputCooccurMatrix.getNonZeroColumnsInRow(i);
            int[] arrScore = inputCooccurMatrix.getNonZeroIntScoresInRow(i);
            double rowLen = arrColumn.length;
            double rowSum = 0.0;
            int j = 0;
            while ((double)j < rowLen) {
                rowSum += (double)arrScore[j];
                ++j;
            }
            j = 0;
            while ((double)j < rowLen) {
                outputTransMatrix.add(i, arrColumn[j], (double)arrScore[j] / rowSum);
                ++j;
            }
            ++i;
        }
        outputTransMatrix.finalizeData(false);
        return true;
    }

    public Matrix transpose() {
        if (!this.isFinalized()) {
            return null;
        }
        if (this.transposeMatrix == null) {
            SparseMatrix curMatrix = this.createSparseMatrix();
            int i = 0;
            while (i < this.rows) {
                int num2 = this.getNonZeroNumInRow(i);
                int j = 0;
                while (j < num2) {
                    curMatrix.add(this.getNonZeroCellInRow(i, j).transpose());
                    ++j;
                }
                ++i;
            }
            curMatrix.finalizeData();
            curMatrix.setTranspose(this);
            this.transposeMatrix = curMatrix;
        }
        return this.transposeMatrix;
    }
}

