/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractFlatSparseMatrix;
import dragon.matrix.AbstractSparseMatrix;
import dragon.matrix.Cell;
import dragon.matrix.Row;
import dragon.matrix.SparseMatrixFactory;
import dragon.util.ByteArrayConvert;
import dragon.util.FileUtil;
import java.io.File;
import java.io.RandomAccessFile;

public abstract class AbstractGiantSparseMatrix
extends AbstractSparseMatrix {
    private static int DEFAULT_FLUSHINTERVAL = 1000000;
    protected String indexFilename;
    protected String matrixFilename;
    protected int totalCell;
    protected RandomAccessFile rafIndex;
    protected RandomAccessFile rafMatrix;
    private int lastAccessIndex;
    private int lastAccessRowLen;
    private long lastAccessRowStart;
    private Row lastAccessRow;
    private byte[] buf;
    protected AbstractFlatSparseMatrix cacheMatrix;
    protected int flushInterval;
    protected SparseMatrixFactory matrixFactory;

    protected abstract Row createRow(int var1, int var2, byte[] var3);

    protected abstract AbstractFlatSparseMatrix createFlatSparseMatrix(boolean var1, boolean var2);

    public AbstractGiantSparseMatrix(String indexFilename, String matrixFilename, int cellDataLength) {
        super(false, false, cellDataLength);
        this.indexFilename = indexFilename;
        this.matrixFilename = matrixFilename;
        this.matrixFactory = null;
        this.flushInterval = 0;
        this.isFinalized = true;
        this.cacheMatrix = null;
        this.initData();
    }

    public AbstractGiantSparseMatrix(String indexFilename, String matrixFilename, int cellDataLength, boolean mergeMode, boolean miniMode) {
        super(mergeMode, miniMode, cellDataLength);
        this.indexFilename = indexFilename;
        this.matrixFilename = matrixFilename;
        this.matrixFactory = new SparseMatrixFactory(matrixFilename, cellDataLength);
        this.flushInterval = DEFAULT_FLUSHINTERVAL;
        this.isFinalized = false;
        this.cacheMatrix = this.createFlatSparseMatrix(mergeMode, miniMode);
    }

    private void initData() {
        block3: {
            try {
                this.buf = new byte[12];
                if (FileUtil.exist(this.indexFilename) && FileUtil.exist(this.matrixFilename)) {
                    this.rafIndex = new RandomAccessFile(this.indexFilename, "r");
                    this.rafMatrix = new RandomAccessFile(this.matrixFilename, "r");
                    this.lastAccessIndex = -1;
                    this.rows = this.rafIndex.readInt();
                    this.columns = this.rafIndex.readInt();
                    this.totalCell = this.rafIndex.readInt();
                    break block3;
                }
                this.rafIndex = null;
                this.rafMatrix = null;
                this.lastAccessIndex = -1;
                this.rows = 0;
                this.columns = 0;
                this.totalCell = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setFlushInterval(int interval) {
        this.flushInterval = interval;
    }

    public void close() {
        try {
            if (this.isFinalized) {
                if (this.rafIndex != null) {
                    this.rafIndex.close();
                }
                if (this.rafMatrix != null) {
                    this.rafMatrix.close();
                }
                this.lastAccessIndex = -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean add(Cell cell) {
        if (this.isFinalized) {
            return false;
        }
        this.cacheMatrix.add(cell);
        if (this.cacheMatrix.getNonZeroNum() >= this.flushInterval) {
            this.flush();
        }
        return true;
    }

    public void flush() {
        if (this.isFinalized) {
            return;
        }
        this.cacheMatrix.finalizeData(true);
        this.matrixFactory.add(this.cacheMatrix);
        this.cacheMatrix.close();
    }

    public boolean finalizeData(boolean sorting) {
        if (this.isFinalized) {
            return false;
        }
        this.flush();
        this.rows = this.matrixFactory.rows();
        this.columns = this.matrixFactory.columns();
        this.totalCell = this.matrixFactory.getNonZeroNum();
        this.isFinalized = true;
        if (this.indexFilename != null) {
            this.matrixFactory.genIndexFile(this.indexFilename);
        }
        if (!this.matrixFactory.getMatrixFilename().equalsIgnoreCase(this.matrixFilename)) {
            File file = new File(this.matrixFilename);
            file.delete();
            new File(this.matrixFactory.getMatrixFilename()).renameTo(file);
        }
        this.initData();
        return true;
    }

    public String getMatrixFilename() {
        return this.matrixFilename;
    }

    public String getIndexFilename() {
        return this.indexFilename;
    }

    public int getNonZeroNum() {
        return this.totalCell;
    }

    public int getNonZeroNumInRow(int row) {
        if (row >= this.rows) {
            return 0;
        }
        return this.getRowLen(row);
    }

    public int getNonZeroColumnInRow(int row, int index) {
        return this.getRow(row).getNonZeroColumn(index);
    }

    public int[] getNonZeroColumnsInRow(int row) {
        if (row >= this.rows) {
            return null;
        }
        int[] oldArray = this.getRow(row).getNonZeroColumns();
        int[] newArray = new int[oldArray.length];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public Cell getCell(int row, int col) {
        if (row >= this.rows) {
            return null;
        }
        return this.getRow(row).getCell(col);
    }

    public Cell getNonZeroCellInRow(int row, int index) {
        return this.getRow(row).getNonZeroCell(index);
    }

    private int getRowLen(int index) {
        try {
            if (this.lastAccessIndex == index) {
                return this.lastAccessRowLen;
            }
            this.rafIndex.seek(index * 16 + 12 + 4);
            this.rafIndex.read(this.buf);
            this.lastAccessRowStart = ByteArrayConvert.toLong(this.buf, 0);
            this.lastAccessRowLen = ByteArrayConvert.toInt(this.buf, 8);
            this.lastAccessRow = null;
            this.lastAccessIndex = index;
            return this.lastAccessRowLen;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    protected Row getRow(int index) {
        if (this.lastAccessIndex == index) {
            if (this.lastAccessRow != null) {
                return this.lastAccessRow;
            }
            return this.loadRow(index, this.lastAccessRowLen);
        }
        return this.loadRow(index, -1);
    }

    private Row loadRow(int index, int rowLen) {
        try {
            Row curRow;
            byte[] data2;
            if (rowLen < 0) {
                rowLen = this.getRowLen(index);
            }
            if (rowLen == 0) {
                data2 = new byte[]{};
            } else {
                this.rafMatrix.seek(this.lastAccessRowStart + 8L);
                data2 = new byte[rowLen * (this.getCellDataLength() + 4)];
                this.rafMatrix.read(data2);
            }
            this.lastAccessRow = curRow = this.createRow(index, rowLen, data2);
            return curRow;
        }
        catch (Exception e) {
            return null;
        }
    }
}

