/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.topicmodel;

import dragon.ir.topicmodel.TopicModel;
import dragon.ir.topicmodel.TwoDimensionModel;
import dragon.nlp.Token;
import dragon.nlp.compare.WeightComparator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class ModelExcelWriter {
    public void write(TopicModel model, int top, String outputFile) {
        this.write(model, null, top, outputFile);
    }

    public void write(TopicModel model, String[] termNameList, int top, String outputFile) {
        try {
            int i;
            int topicNum = model.getTopicNum();
            WritableFont arial14font = new WritableFont(WritableFont.ARIAL, 14);
            WritableCellFormat arial14format = new WritableCellFormat(arial14font);
            WritableWorkbook workbook = Workbook.createWorkbook((File)new File(outputFile));
            WritableSheet sheet = workbook.createSheet("Topic Model", 0);
            if (termNameList == null) {
                termNameList = new String[model.getTermNum()];
                i = 0;
                while (i < model.getTermNum()) {
                    termNameList[i] = model.getTermName(i);
                    ++i;
                }
            }
            i = 0;
            while (i < topicNum) {
                sheet.addCell((WritableCell)new Label(i * 2, 0, "Topic" + (i + 1), (CellFormat)arial14format));
                ArrayList termList = this.sortThemeTerm(model.getTopic(i), termNameList, top);
                this.saveTermList(sheet, i * 2, 1, termList);
                ++i;
            }
            workbook.write();
            workbook.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void write(TwoDimensionModel model, int top, String outputFile) {
        this.write(model, null, null, top, outputFile);
    }

    public void write(TwoDimensionModel model, String[] viewTermList, String[] topicTermList, int top, String outputFile) {
        try {
            ArrayList termList;
            int i;
            int viewNum = model.getViewNum();
            int topicNum = model.getTopicNum();
            WritableFont arial14font = new WritableFont(WritableFont.ARIAL, 14);
            WritableCellFormat arial14format = new WritableCellFormat(arial14font);
            WritableWorkbook workbook = Workbook.createWorkbook((File)new File(outputFile));
            WritableSheet sheet = workbook.createSheet("View-Topic Model", 0);
            sheet.addCell((WritableCell)new Label(0, 0, "View-Topic", (CellFormat)arial14format));
            sheet.addCell((WritableCell)new Label(1, 0, "View Content", (CellFormat)arial14format));
            if (viewTermList == null) {
                viewTermList = new String[model.getViewTermNum()];
                i = 0;
                while (i < viewTermList.length) {
                    viewTermList[i] = model.getViewTermName(i);
                    ++i;
                }
            }
            if (topicTermList == null) {
                topicTermList = new String[model.getTopicTermNum()];
                i = 0;
                while (i < topicTermList.length) {
                    topicTermList[i] = model.getTopicTermName(i);
                    ++i;
                }
            }
            i = 0;
            while (i < viewNum) {
                sheet.addCell((WritableCell)new Label(0, (i + 1) * top + 1, "View " + (i + 1), (CellFormat)arial14format));
                termList = this.sortThemeTerm(model.getView(i), viewTermList, top);
                this.saveTermList(sheet, 1, (i + 1) * top + 1, termList);
                int j = 0;
                while (j < topicNum) {
                    termList = this.sortThemeTerm(model.getViewTopic(i, j), topicTermList, top);
                    this.saveTermList(sheet, 2 + j * 2 + 1, (i + 1) * top + 1, termList);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < topicNum) {
                sheet.addCell((WritableCell)new Label(3 + i * 2, 0, "Topic " + (i + 1), (CellFormat)arial14format));
                termList = this.sortThemeTerm(model.getCommonTopic(i), topicTermList, top);
                this.saveTermList(sheet, 3 + i * 2, 1, termList);
                ++i;
            }
            workbook.write();
            workbook.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void saveTermList(WritableSheet sheet, int colNum, int rowNum, ArrayList list2) {
        try {
            int i = 0;
            while (i < list2.size()) {
                Token token2 = (Token)list2.get(i);
                sheet.addCell((WritableCell)new Label(colNum, rowNum + i, token2.getName()));
                sheet.addCell((WritableCell)new Number(colNum + 1, rowNum + i, token2.getWeight()));
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ArrayList sortThemeTerm(double[] termProbs, String[] termKeyList, int top) {
        ArrayList newList = new ArrayList();
        ArrayList<Token> termList = new ArrayList<Token>();
        int i = 0;
        while (i < termProbs.length) {
            String termKey = termKeyList[i];
            Token token2 = new Token(termKey);
            token2.setIndex(i);
            token2.setWeight(termProbs[i]);
            termList.add(token2);
            ++i;
        }
        Collections.sort(termList, new WeightComparator());
        if (top > termList.size()) {
            top = termList.size();
        }
        i = 0;
        while (i < top) {
            newList.add(termList.get(i));
            ++i;
        }
        return newList;
    }
}

