/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.topicmodel;

import dragon.ir.index.IndexReader;
import dragon.ir.index.sequence.SequenceIndexReader;
import dragon.ir.topicmodel.AbstractTopicModel;
import java.util.Date;
import java.util.Random;

public class GibbsLDA
extends AbstractTopicModel {
    private int indexType;
    private int tokenNum;
    private double alpha;
    private double beta;
    private double wBeta;
    private double tAlpha;

    public GibbsLDA(SequenceIndexReader indexReader, double alpha, double beta) {
        this(indexReader, alpha, beta, 1);
    }

    public GibbsLDA(IndexReader indexReader, double alpha, double beta) {
        this(indexReader, alpha, beta, 0);
    }

    private GibbsLDA(IndexReader indexReader, double alpha, double beta, int indexType) {
        super(indexReader);
        this.alpha = alpha;
        this.beta = beta;
        this.iterations = 500;
        this.termNum = indexReader.getCollection().getTermNum();
        this.tokenNum = (int)indexReader.getCollection().getTermCount();
        this.docNum = indexReader.getCollection().getDocNum();
        this.wBeta = (double)this.termNum * beta;
        this.indexType = indexType;
    }

    public boolean estimateModel(int topicNum) {
        int j;
        this.themeNum = topicNum;
        this.tAlpha = (double)this.themeNum * this.alpha;
        int[][] arrTTCount = new int[this.termNum][this.themeNum];
        int[][] arrDTCount = new int[this.docNum][this.themeNum];
        int[] arrTerm = new int[this.tokenNum];
        int[] arrDoc = new int[this.tokenNum];
        int[] arrTermLabel = new int[this.tokenNum];
        this.printStatus(new Date().toString() + " Reading sequence...");
        if (this.indexType == 0) {
            this.readSequence(this.indexReader, arrTerm, arrDoc);
        } else {
            this.readSequence((SequenceIndexReader)this.indexReader, arrTerm, arrDoc);
        }
        this.run(this.seed, arrTerm, arrDoc, arrTermLabel, arrTTCount, arrDTCount);
        this.arrThemeTerm = new double[this.themeNum][this.termNum];
        int i = 0;
        while (i < this.themeNum) {
            double topicSum = this.wBeta;
            j = 0;
            while (j < this.termNum) {
                topicSum += (double)arrTTCount[j][i];
                ++j;
            }
            j = 0;
            while (j < this.termNum) {
                this.arrThemeTerm[i][j] = ((double)arrTTCount[j][i] + this.beta) / topicSum;
                ++j;
            }
            ++i;
        }
        this.arrDocTheme = new double[this.docNum][this.themeNum];
        i = 0;
        while (i < this.docNum) {
            double docSum = this.tAlpha;
            j = 0;
            while (j < this.themeNum) {
                docSum += (double)arrDTCount[i][j];
                ++j;
            }
            j = 0;
            while (j < this.themeNum) {
                this.arrDocTheme[i][j] = ((double)arrDTCount[i][j] + this.alpha) / docSum;
                ++j;
            }
            ++i;
        }
        return true;
    }

    private void run(int seed, int[] arrTerm, int[] arrDoc, int[] arrTermLabel, int[][] arrTTCount, int[][] arrDTCount) {
        int k;
        int docIndex;
        int termIndex;
        int topic;
        int[] arrTopicCount = new int[this.themeNum];
        int[] arrOrder = new int[this.tokenNum];
        Random random = new Random();
        if (seed >= 0) {
            random.setSeed(seed);
        }
        this.printStatus(new Date().toString() + " Starting random initialization...");
        int i = 0;
        while (i < this.tokenNum) {
            arrTermLabel[i] = topic = random.nextInt(this.themeNum);
            termIndex = arrTerm[i];
            docIndex = arrDoc[i];
            int[] nArray = arrTTCount[termIndex];
            int n = topic;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = arrDTCount[docIndex];
            int n2 = topic;
            nArray2[n2] = nArray2[n2] + 1;
            int n3 = topic;
            arrTopicCount[n3] = arrTopicCount[n3] + 1;
            ++i;
        }
        this.printStatus(new Date().toString() + " Determining random update sequence...");
        i = 0;
        while (i < this.tokenNum) {
            arrOrder[i] = i;
            ++i;
        }
        i = 0;
        while (i < this.tokenNum - 1) {
            k = i + random.nextInt(this.tokenNum - i);
            int j = arrOrder[k];
            arrOrder[k] = arrOrder[i];
            arrOrder[i] = j;
            ++i;
        }
        int iter2 = 0;
        while (iter2 < this.iterations) {
            this.printStatus(new Date().toString() + " Iteration #" + (iter2 + 1));
            k = 0;
            while (k < this.tokenNum) {
                i = arrOrder[k];
                termIndex = arrTerm[i];
                docIndex = arrDoc[i];
                int n = topic = arrTermLabel[i];
                arrTopicCount[n] = arrTopicCount[n] - 1;
                int[] nArray = arrTTCount[termIndex];
                int n4 = topic;
                nArray[n4] = nArray[n4] - 1;
                int[] nArray3 = arrDTCount[docIndex];
                int n5 = topic;
                nArray3[n5] = nArray3[n5] - 1;
                arrTermLabel[i] = topic = this.sampleTopic(random, arrTTCount[termIndex], arrDTCount[docIndex], arrTopicCount);
                int[] nArray4 = arrTTCount[termIndex];
                int n6 = topic;
                nArray4[n6] = nArray4[n6] + 1;
                int[] nArray5 = arrDTCount[docIndex];
                int n7 = topic;
                nArray5[n7] = nArray5[n7] + 1;
                int n8 = topic;
                arrTopicCount[n8] = arrTopicCount[n8] + 1;
                ++k;
            }
            ++iter2;
        }
    }

    private int sampleTopic(Random random, int[] arrTTCount, int[] arrDTCount, int[] arrTopicCount) {
        double totalProb = 0.0;
        double[] arrProb = new double[this.themeNum];
        int j = 0;
        while (j < this.themeNum) {
            arrProb[j] = ((double)arrTTCount[j] + this.beta) / ((double)arrTopicCount[j] + this.wBeta) * ((double)arrDTCount[j] + this.alpha);
            totalProb += arrProb[j];
            ++j;
        }
        double r = totalProb * random.nextDouble();
        double max2 = arrProb[0];
        int topic = 0;
        while (r > max2) {
            max2 += arrProb[++topic];
        }
        return topic;
    }

    private void readSequence(SequenceIndexReader indexReader, int[] arrTerm, int[] arrDoc) {
        int docNum = indexReader.getCollection().getDocNum();
        int count2 = 0;
        int i = 0;
        while (i < docNum) {
            int[] arrSeq = indexReader.getTermIndexList(i);
            if (arrSeq != null && arrSeq.length != 0) {
                int j = 0;
                while (j < arrSeq.length) {
                    arrTerm[count2 + j] = arrSeq[j];
                    arrDoc[count2 + j] = i;
                    ++j;
                }
                count2 += arrSeq.length;
            }
            ++i;
        }
    }

    private void readSequence(IndexReader indexReader, int[] arrTerm, int[] arrDoc) {
        int docNum = indexReader.getCollection().getDocNum();
        int count2 = 0;
        int i = 0;
        while (i < docNum) {
            int[] arrIndex = indexReader.getTermIndexList(i);
            int[] arrFreq = indexReader.getTermFrequencyList(i);
            if (arrIndex != null && arrIndex.length != 0) {
                int j = 0;
                while (j < arrIndex.length) {
                    int k = 0;
                    while (k < arrFreq[j]) {
                        arrTerm[count2 + k] = arrIndex[j];
                        arrDoc[count2 + k] = i;
                        ++k;
                    }
                    count2 += arrFreq[j];
                    ++j;
                }
            }
            ++i;
        }
    }
}

