/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.summarize;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.summarize.AbstractStructureSum;
import dragon.ir.summarize.StructureSummarizer;
import dragon.ir.summarize.TextUnit;
import dragon.ir.summarize.TopicSummary;
import dragon.nlp.Token;
import dragon.nlp.compare.IndexComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class TermGenerativeSum
extends AbstractStructureSum
implements StructureSummarizer {
    private double bkgCoeffi;

    public TermGenerativeSum(IndexReader indexReader, double bkgCoefficient) {
        super(indexReader);
        this.bkgCoeffi = bkgCoefficient;
    }

    public TopicSummary summarize(ArrayList docSet, int maxLength) {
        Token curToken;
        int j;
        int docNum = docSet.size();
        SortedArray termList = new SortedArray(new IndexComparator());
        int i = 0;
        while (i < docNum) {
            IRDoc curDoc = (IRDoc)docSet.get(i);
            int[] arrIndex = this.indexReader.getTermIndexList(curDoc.getIndex());
            int[] arrFreq = this.indexReader.getTermFrequencyList(curDoc.getIndex());
            j = 0;
            while (j < arrIndex.length) {
                curToken = new Token(null);
                curToken.setIndex(arrIndex[j]);
                curToken.setFrequency(arrFreq[j]);
                if (!termList.add(curToken)) {
                    ((Token)termList.get(termList.insertedPos())).addFrequency(curToken.getFrequency());
                }
                ++j;
            }
            ++i;
        }
        int iterationNum = 15;
        double[] arrProb = new double[termList.size()];
        double[] arrCollectionProb = new double[termList.size()];
        double collectionTermCount = this.indexReader.getCollection().getTermCount();
        i = 0;
        while (i < termList.size()) {
            curToken = (Token)termList.get(i);
            curToken.setWeight(1.0 / (double)termList.size());
            arrCollectionProb[i] = this.bkgCoeffi * (double)this.indexReader.getIRTerm(curToken.getIndex()).getFrequency() / collectionTermCount;
            ++i;
        }
        i = 0;
        while (i < iterationNum) {
            double weightSum = 0.0;
            j = 0;
            while (j < termList.size()) {
                curToken = (Token)termList.get(j);
                arrProb[j] = (1.0 - this.bkgCoeffi) * curToken.getWeight() / ((1.0 - this.bkgCoeffi) * curToken.getWeight() + arrCollectionProb[j]) * (double)curToken.getFrequency();
                weightSum += arrProb[j];
                ++j;
            }
            j = 0;
            while (j < termList.size()) {
                ((Token)termList.get(j)).setWeight(arrProb[j] / weightSum);
                ++j;
            }
            ++i;
        }
        TopicSummary summary = new TopicSummary(1);
        int termNum = Math.min(termList.size(), maxLength);
        i = 0;
        while (i < termNum) {
            curToken = (Token)termList.get(i);
            TextUnit curTerm = new TextUnit(this.indexReader.getTermKey(curToken.getIndex()), curToken.getIndex(), curToken.getWeight());
            summary.addText(curTerm);
            ++i;
        }
        summary.sortByWegiht();
        return summary;
    }
}

