/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.summarize;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IndexReader;
import dragon.ir.summarize.AbstractStructureSum;
import dragon.ir.summarize.StructureSummarizer;
import dragon.ir.summarize.TextUnit;
import dragon.ir.summarize.TopicSummary;
import dragon.nlp.Token;
import dragon.nlp.compare.IndexComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class RelationGenerativeSum
extends AbstractStructureSum
implements StructureSummarizer {
    private double bkgCoeffi;

    public RelationGenerativeSum(IndexReader indexReader, double bkgCoefficient) {
        super(indexReader);
        this.bkgCoeffi = bkgCoefficient;
    }

    public TopicSummary summarize(ArrayList docSet, int maxLength) {
        Token curToken;
        int j;
        int docNum = docSet.size();
        SortedArray relationList = new SortedArray(new IndexComparator());
        int i = 0;
        while (i < docNum) {
            IRDoc curDoc = (IRDoc)docSet.get(i);
            int[] arrIndex = this.indexReader.getRelationIndexList(curDoc.getIndex());
            int[] arrFreq = this.indexReader.getRelationFrequencyList(curDoc.getIndex());
            j = 0;
            while (j < arrIndex.length) {
                curToken = new Token(null);
                curToken.setIndex(arrIndex[j]);
                curToken.setFrequency(arrFreq[j]);
                if (!relationList.add(curToken)) {
                    ((Token)relationList.get(relationList.insertedPos())).addFrequency(curToken.getFrequency());
                }
                ++j;
            }
            ++i;
        }
        int iterationNum = 15;
        double[] arrProb = new double[relationList.size()];
        double[] arrCollectionProb = new double[relationList.size()];
        double collectionRelationCount = this.indexReader.getCollection().getTermCount();
        i = 0;
        while (i < relationList.size()) {
            curToken = (Token)relationList.get(i);
            curToken.setWeight(1.0 / (double)relationList.size());
            arrCollectionProb[i] = this.bkgCoeffi * (double)this.indexReader.getIRRelation(curToken.getIndex()).getFrequency() / collectionRelationCount;
            ++i;
        }
        i = 0;
        while (i < iterationNum) {
            double weightSum = 0.0;
            j = 0;
            while (j < relationList.size()) {
                curToken = (Token)relationList.get(j);
                arrProb[j] = (1.0 - this.bkgCoeffi) * curToken.getWeight() / ((1.0 - this.bkgCoeffi) * curToken.getWeight() + arrCollectionProb[j]) * (double)curToken.getFrequency();
                weightSum += arrProb[j];
                ++j;
            }
            j = 0;
            while (j < relationList.size()) {
                ((Token)relationList.get(j)).setWeight(arrProb[j] / weightSum);
                ++j;
            }
            ++i;
        }
        TopicSummary summary = new TopicSummary(2);
        int relationNum = Math.min(relationList.size(), maxLength);
        i = 0;
        while (i < relationNum) {
            curToken = (Token)relationList.get(i);
            IRRelation curRelation = this.indexReader.getIRRelation(curToken.getIndex());
            String curText = this.indexReader.getTermKey(curRelation.getFirstTerm()) + "<->" + this.indexReader.getTermKey(curRelation.getSecondTerm());
            TextUnit curTextUnit = new TextUnit(curText, curToken.getIndex(), curToken.getWeight());
            summary.addText(curTextUnit);
            ++i;
        }
        summary.sortByWegiht();
        return summary;
    }
}

