/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.smooth;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.FullRankSearcher;
import dragon.ir.search.smooth.AbstractMixtureWeightEM;
import dragon.ir.search.smooth.DocFirstTransSmoother;
import dragon.ir.search.smooth.OkapiSmoother;
import dragon.ir.search.smooth.QueryFirstTransSmoother;

public class DocTransMixtureWeightEM
extends AbstractMixtureWeightEM {
    private RelSimpleQuery query;
    private QueryFirstTransSmoother querySmoother;
    private double queryWeight;
    private DocFirstTransSmoother docSmoother;

    public DocTransMixtureWeightEM(IndexReader indexReader, int iterationNum, QueryFirstTransSmoother querySmoother) {
        super(indexReader, 2, iterationNum, false);
        this.querySmoother = querySmoother;
    }

    public DocTransMixtureWeightEM(IndexReader indexReader, int iterationNum, DocFirstTransSmoother docSmoother) {
        super(indexReader, 2, iterationNum, true);
        this.docSmoother = docSmoother;
    }

    protected void setInitialParameters(double[] arrCoefficient, IRDoc[] arrDoc) {
        arrCoefficient[0] = 0.7;
        arrCoefficient[1] = 0.3;
        FullRankSearcher searcher = new FullRankSearcher(this.indexReader, new OkapiSmoother(this.indexReader.getCollection()));
        int docNum = searcher.search(this.query);
        double sum2 = 0.0;
        int i = 0;
        while (i < docNum) {
            arrDoc[i] = this.indexReader.getDoc(i);
            arrDoc[i].setWeight(1.0 / (double)docNum);
            if (arrDoc[i].getTermCount() == 0) {
                arrDoc[i].setTermCount(1);
            }
            if (arrDoc[i].getRelationCount() == 0) {
                arrDoc[i].setRelationCount(1);
            }
            ++i;
        }
        i = 0;
        while (i < docNum) {
            IRDoc curDoc = searcher.getIRDoc(i);
            arrDoc[curDoc.getIndex()].setWeight(curDoc.getWeight());
            sum2 += curDoc.getWeight();
            ++i;
        }
        i = 0;
        while (i < arrDoc.length) {
            arrDoc[i].setWeight(arrDoc[i].getWeight() / sum2);
            ++i;
        }
    }

    protected void setDoc(IRDoc curDoc) {
        this.docSmoother.setDoc(curDoc);
    }

    protected void setQueryTerm(SimpleTermPredicate curQueryTerm) {
        this.queryWeight = curQueryTerm.getWeight();
        this.querySmoother.setQueryTerm(curQueryTerm);
    }

    protected void init(RelSimpleQuery query) {
        this.query = query;
    }

    protected void getComponentValue(IRDoc curDoc, int freq, double[] arrComp) {
        this.querySmoother.setDoc(curDoc);
        arrComp[0] = this.querySmoother.getBasicSmoother().getSmoothedProb(freq) / this.queryWeight;
        arrComp[1] = this.querySmoother.getTranslationProb(curDoc.getIndex());
    }

    protected void getComponentValue(SimpleTermPredicate curQueryTerm, int freq, double[] arrComp) {
        this.docSmoother.setQueryTerm(curQueryTerm);
        arrComp[0] = this.docSmoother.getBasicSmoother().getSmoothedProb(freq) / curQueryTerm.getWeight();
        arrComp[1] = this.docSmoother.getTranslationProb(curQueryTerm.getIndex());
    }
}

