/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.smooth;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.query.Predicate;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleTermPredicate;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class AbstractMixtureWeightEM {
    protected IndexReader indexReader;
    protected int iterationNum;
    protected int componentNum;
    private PrintWriter statusOut;
    private boolean docFirst;

    public AbstractMixtureWeightEM(IndexReader indexReader, int componentNum, int iterationNum, boolean docFirst) {
        this.indexReader = indexReader;
        this.iterationNum = iterationNum;
        this.componentNum = componentNum;
        this.docFirst = docFirst;
    }

    protected abstract void setInitialParameters(double[] var1, IRDoc[] var2);

    protected abstract void init(RelSimpleQuery var1);

    protected abstract void setDoc(IRDoc var1);

    protected abstract void setQueryTerm(SimpleTermPredicate var1);

    protected abstract void getComponentValue(SimpleTermPredicate var1, int var2, double[] var3);

    protected abstract void getComponentValue(IRDoc var1, int var2, double[] var3);

    public void setStatusOut(PrintWriter out) {
        this.statusOut = out;
    }

    public double[] estimateModelCoefficient(RelSimpleQuery query) {
        if (this.docFirst) {
            return this.breadthFirstEstimate(query);
        }
        return this.depthFirstEstimate(query);
    }

    private double[] breadthFirstEstimate(RelSimpleQuery query) {
        SimpleTermPredicate[] arrPredicate = this.checkSimpleTermQuery(query);
        this.init(query);
        double[] arrPreParam = new double[this.componentNum];
        double[] arrParam = new double[this.componentNum];
        double[] arrParamDocSum = new double[this.componentNum];
        double[] arrComp = new double[this.componentNum];
        int termNum = arrPredicate.length;
        int docNum = this.getDocNum();
        double[] arrDocWeight = new double[docNum];
        IRDoc[] arrDoc = new IRDoc[docNum];
        this.setInitialParameters(arrPreParam, arrDoc);
        this.printStatus("Estimating the coefficients of the mixed model...");
        int k = 0;
        while (k < this.iterationNum) {
            this.printStatus("Iteration #" + (k + 1));
            double allDocSum = 0.0;
            int m = 0;
            while (m < this.componentNum) {
                arrParam[m] = 0.0;
                ++m;
            }
            int i = 0;
            while (i < docNum) {
                double docSum = arrDoc[i].getWeight();
                m = 0;
                while (m < this.componentNum) {
                    arrParamDocSum[m] = 0.0;
                    ++m;
                }
                this.setDoc(arrDoc[i]);
                int j = 0;
                while (j < termNum) {
                    IRTerm docTerm = this.indexReader.getIRTerm(arrPredicate[j].getIndex(), i);
                    this.getComponentValue(arrPredicate[j], docTerm.getFrequency(), arrComp);
                    double termProb = 0.0;
                    m = 0;
                    while (m < this.componentNum) {
                        arrComp[m] = arrPreParam[m] * arrComp[m];
                        termProb += arrComp[m];
                        ++m;
                    }
                    docSum *= termProb;
                    m = 0;
                    while (m < this.componentNum) {
                        int n = m;
                        arrParamDocSum[n] = arrParamDocSum[n] + arrComp[m] / termProb;
                        ++m;
                    }
                    ++j;
                }
                m = 0;
                while (m < this.componentNum) {
                    int n = m;
                    arrParam[n] = arrParam[n] + arrDoc[i].getWeight() * arrParamDocSum[m];
                    ++m;
                }
                arrDocWeight[i] = docSum;
                allDocSum += arrDocWeight[i];
                ++i;
            }
            m = 0;
            while (m < this.componentNum) {
                arrPreParam[m] = arrParam[m] / (double)termNum;
                this.printStatus("Coefficient #" + (m + 1) + " " + arrPreParam[m]);
                ++m;
            }
            m = 0;
            while (m < docNum) {
                arrDoc[m].setWeight(arrDocWeight[m] / allDocSum);
                ++m;
            }
            ++k;
        }
        this.printStatus("");
        return arrPreParam;
    }

    /*
     * Unable to fully structure code
     */
    private double[] depthFirstEstimate(RelSimpleQuery query) {
        arrPredicate = this.checkSimpleTermQuery(query);
        this.init(query);
        arrPreParam = new double[this.componentNum];
        arrParam = new double[this.componentNum];
        arrComp = new double[this.componentNum];
        termNum = arrPredicate.length;
        docNum = this.getDocNum();
        arrDocWeight = new double[docNum];
        arrDoc = new IRDoc[docNum];
        this.setInitialParameters(arrPreParam, arrDoc);
        this.printStatus("Estimating the coefficients of the mixed model...");
        count = 0;
        while (count < this.iterationNum) {
            this.printStatus("Iteration #" + (count + 1));
            i = 0;
            while (i < docNum) {
                arrDocWeight[i] = arrDoc[i].getWeight();
                ++i;
            }
            m = 0;
            while (m < this.componentNum) {
                arrParam[m] = 0.0;
                ++m;
            }
            i = 0;
            while (i < arrPredicate.length) {
                this.setQueryTerm(arrPredicate[i]);
                arrIndex = this.indexReader.getTermDocIndexList(arrPredicate[i].getIndex());
                arrFreq = this.indexReader.getTermDocFrequencyList(arrPredicate[i].getIndex());
                k = 0;
                j = 0;
                ** GOTO lbl68
                {
                    this.getComponentValue(arrDoc[k], 0, arrComp);
                    termProb = 0.0;
                    m = 0;
                    while (m < this.componentNum) {
                        arrComp[m] = arrPreParam[m] * arrComp[m];
                        termProb += arrComp[m];
                        ++m;
                    }
                    arrDocWeight[k] = arrDocWeight[k] * termProb;
                    m = 0;
                    while (m < this.componentNum) {
                        v0 = m;
                        arrParam[v0] = arrParam[v0] + arrDoc[k].getWeight() * arrComp[m] / termProb;
                        ++m;
                    }
                    ++k;
                    do {
                        if (k < arrIndex[j]) continue block4;
                        this.getComponentValue(arrDoc[k], arrFreq[j], arrComp);
                        termProb = 0.0;
                        m = 0;
                        while (m < this.componentNum) {
                            arrComp[m] = arrPreParam[m] * arrComp[m];
                            termProb += arrComp[m];
                            ++m;
                        }
                        arrDocWeight[k] = arrDocWeight[k] * termProb;
                        m = 0;
                        while (m < this.componentNum) {
                            v1 = m;
                            arrParam[v1] = arrParam[v1] + arrDoc[k].getWeight() * arrComp[m] / termProb;
                            ++m;
                        }
                        ++k;
                        ++j;
lbl68:
                        // 2 sources

                    } while (j < arrIndex.length);
                }
                while (k < docNum) {
                    this.getComponentValue(arrDoc[k], 0, arrComp);
                    termProb = 0.0;
                    m = 0;
                    while (m < this.componentNum) {
                        arrComp[m] = arrPreParam[m] * arrComp[m];
                        termProb += arrComp[m];
                        ++m;
                    }
                    arrDocWeight[k] = arrDocWeight[k] * termProb;
                    m = 0;
                    while (m < this.componentNum) {
                        v2 = m;
                        arrParam[v2] = arrParam[v2] + arrDoc[k].getWeight() * arrComp[m] / termProb;
                        ++m;
                    }
                    ++k;
                }
                ++i;
            }
            m = 0;
            while (m < this.componentNum) {
                arrPreParam[m] = arrParam[m] / (double)termNum;
                this.printStatus("Coefficient #" + (m + 1) + " " + arrPreParam[m]);
                ++m;
            }
            allSum = 0.0;
            i = 0;
            while (i < docNum) {
                allSum += arrDocWeight[i];
                ++i;
            }
            i = 0;
            while (i < docNum) {
                arrDoc[i].setWeight(arrDocWeight[i] / allSum);
                ++i;
            }
            ++count;
        }
        this.printStatus("");
        return arrPreParam;
    }

    protected int getDocNum() {
        return this.indexReader.getCollection().getDocNum();
    }

    protected IRDoc getDoc(int seq2) {
        return this.indexReader.getDoc(seq2);
    }

    private void printStatus(String line) {
        try {
            System.out.println(line);
            if (this.statusOut != null) {
                this.statusOut.write(line + "\n");
                this.statusOut.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SimpleTermPredicate[] checkSimpleTermQuery(RelSimpleQuery query) {
        ArrayList<SimpleTermPredicate> list2 = new ArrayList<SimpleTermPredicate>();
        int i = 0;
        while (i < query.getChildNum()) {
            if (((Predicate)query.getChild(i)).isTermPredicate()) {
                IRTerm curIRTerm;
                SimpleTermPredicate predicate = (SimpleTermPredicate)query.getChild(i);
                if (predicate.getDocFrequency() == 0 && (curIRTerm = this.indexReader.getIRTerm(predicate.getKey())) != null) {
                    predicate.setDocFrequency(curIRTerm.getDocFrequency());
                    predicate.setFrequency(curIRTerm.getFrequency());
                    predicate.setIndex(curIRTerm.getIndex());
                }
                if (predicate.getDocFrequency() > 0) {
                    list2.add(predicate);
                }
            }
            ++i;
        }
        SimpleTermPredicate[] arrPredicate = new SimpleTermPredicate[list2.size()];
        i = 0;
        while (i < list2.size()) {
            arrPredicate[i] = ((SimpleTermPredicate)list2.get(i)).copy();
            ++i;
        }
        return arrPredicate;
    }
}

