/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.feedback;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.Searcher;
import dragon.ir.search.feedback.AbstractFeedback;
import dragon.nlp.Token;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.compare.WeightComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class RocchioFeedback
extends AbstractFeedback {
    private int expandTermNum;
    private boolean useBM25;
    private double param1;
    private double param2;
    private double avgDocLength;

    public RocchioFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double relevantDocCoeffi) {
        super(searcher, feedbackDocNum, relevantDocCoeffi);
        this.expandTermNum = expandTermNum;
        this.useBM25 = false;
    }

    public RocchioFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double relevantDocCoeffi, double bm25k1, double bm25b) {
        super(searcher, feedbackDocNum, relevantDocCoeffi);
        this.expandTermNum = expandTermNum;
        this.useBM25 = true;
        IRCollection collection = searcher.getIndexReader().getCollection();
        this.avgDocLength = (double)collection.getTermCount() * 1.0 / (double)collection.getDocNum();
        this.param1 = bm25k1 * (1.0 - bm25b);
        this.param2 = bm25k1 * bm25b;
    }

    protected ArrayList estimateNewQueryModel(IRQuery oldQuery) {
        Token curToken;
        int releDocNum;
        IndexReader indexReader = this.searcher.getIndexReader();
        this.searcher.search(oldQuery);
        int n = releDocNum = this.feedbackDocNum < this.searcher.getRetrievedDocNum() ? this.feedbackDocNum : this.searcher.getRetrievedDocNum();
        if (releDocNum == 0) {
            return null;
        }
        int totalDocNum = indexReader.getCollection().getDocNum();
        SortedArray termList = new SortedArray(new IndexComparator());
        int i = 0;
        while (i < releDocNum) {
            IRDoc curDoc = this.searcher.getIRDoc(i);
            int[] arrIndex = indexReader.getTermIndexList(curDoc.getIndex());
            int[] arrFreq = indexReader.getTermFrequencyList(curDoc.getIndex());
            int j = 0;
            while (j < arrIndex.length) {
                curToken = new Token(null);
                curToken.setIndex(arrIndex[j]);
                double weight = this.getTermWeight(curDoc, arrFreq[j]);
                curToken.setWeight(weight);
                if (!termList.add(curToken)) {
                    curToken = (Token)termList.get(termList.insertedPos());
                    curToken.setWeight(curToken.getWeight() + weight);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < termList.size()) {
            curToken = (Token)termList.get(i);
            curToken.setWeight(curToken.getWeight() * this.getIDF(totalDocNum, indexReader.getIRTerm(curToken.getIndex()).getDocFrequency()));
            ++i;
        }
        termList.setComparator(new WeightComparator(true));
        int predicateNum = oldQuery.getChildNum() + this.expandTermNum < termList.size() ? oldQuery.getChildNum() + this.expandTermNum : termList.size();
        ArrayList<SimpleTermPredicate> newPredicateList = new ArrayList<SimpleTermPredicate>(predicateNum);
        double weightSum = 0.0;
        i = 0;
        while (i < predicateNum) {
            curToken = (Token)termList.get(i);
            if (curToken.getWeight() <= 0.0) {
                predicateNum = i;
            } else {
                weightSum += ((Token)termList.get(i)).getWeight();
            }
            ++i;
        }
        i = 0;
        while (i < predicateNum) {
            curToken = (Token)termList.get(i);
            SimpleTermPredicate curPredicate = this.buildSimpleTermPredicate(curToken.getIndex(), curToken.getWeight() / weightSum);
            newPredicateList.add(curPredicate);
            ++i;
        }
        return newPredicateList;
    }

    private double getTermWeight(IRDoc curDoc, int termFreq) {
        if (this.useBM25) {
            return (double)termFreq / (this.param1 + this.param2 * (double)curDoc.getTermCount() / this.avgDocLength + (double)termFreq);
        }
        return termFreq;
    }

    private double getIDF(int collectionDocNum, int termDocFrequency) {
        return Math.log(((double)collectionDocNum + 1.0) / ((double)termDocFrequency + 0.5));
    }
}

