/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.feedback;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.Searcher;
import dragon.ir.search.feedback.AbstractFeedback;
import dragon.matrix.DoubleSparseMatrix;
import dragon.nlp.Token;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.compare.WeightComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class PhraseTransFeedback
extends AbstractFeedback {
    private IndexReader phraseIndexer;
    private DoubleSparseMatrix transMatrix;
    private int expandTermNum;
    private double bkgCoeffi;
    private boolean selfTranslation;

    public PhraseTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, IndexReader phraseIndexer, double bkgCoeffi) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.bkgCoeffi = bkgCoeffi;
        this.transMatrix = null;
        this.phraseIndexer = phraseIndexer;
        this.selfTranslation = true;
    }

    public PhraseTransFeedback(Searcher searcher, int feedbackDocNum, int expandTermNum, double feedbackCoeffi, IndexReader phraseIndexer, double bkgCoeffi, DoubleSparseMatrix transMatrix) {
        super(searcher, feedbackDocNum, feedbackCoeffi);
        this.expandTermNum = expandTermNum;
        this.bkgCoeffi = bkgCoeffi;
        this.transMatrix = transMatrix;
        this.phraseIndexer = phraseIndexer;
        this.selfTranslation = false;
    }

    protected ArrayList estimateNewQueryModel(IRQuery oldQuery) {
        int docNum;
        this.searcher.search(oldQuery);
        int n = docNum = this.feedbackDocNum < this.searcher.getRetrievedDocNum() ? this.feedbackDocNum : this.searcher.getRetrievedDocNum();
        if (docNum == 0) {
            return null;
        }
        ArrayList phraseList = this.generativeModel(docNum);
        SortedArray termList = this.translate(phraseList);
        int predicateNum = oldQuery.getChildNum() + this.expandTermNum < termList.size() ? oldQuery.getChildNum() + this.expandTermNum : termList.size();
        ArrayList<SimpleTermPredicate> newPredicateList = new ArrayList<SimpleTermPredicate>(predicateNum);
        double weightSum = 0.0;
        int i = 0;
        while (i < predicateNum) {
            weightSum += ((Token)termList.get(i)).getWeight();
            ++i;
        }
        i = 0;
        while (i < predicateNum) {
            Token curToken = (Token)termList.get(i);
            SimpleTermPredicate curPredicate = this.buildSimpleTermPredicate(curToken.getIndex(), curToken.getWeight() / weightSum);
            newPredicateList.add(curPredicate);
            ++i;
        }
        return newPredicateList;
    }

    private ArrayList generativeModel(int docNum) {
        Token curToken;
        int j;
        SortedArray phraseList = new SortedArray(new IndexComparator());
        int i = 0;
        while (i < docNum) {
            IRDoc curDoc = this.searcher.getIRDoc(i);
            int[] arrIndex = this.phraseIndexer.getTermIndexList(curDoc.getIndex());
            int[] arrFreq = this.phraseIndexer.getTermFrequencyList(curDoc.getIndex());
            j = 0;
            while (j < arrIndex.length) {
                curToken = new Token(null);
                curToken.setIndex(arrIndex[j]);
                curToken.setFrequency(arrFreq[j]);
                if (!phraseList.add(curToken)) {
                    ((Token)phraseList.get(phraseList.insertedPos())).addFrequency(curToken.getFrequency());
                }
                ++j;
            }
            ++i;
        }
        int iterationNum = 15;
        double[] arrProb = new double[phraseList.size()];
        double[] arrCollectionProb = new double[phraseList.size()];
        double collectionTermCount = this.phraseIndexer.getCollection().getTermCount();
        i = 0;
        while (i < phraseList.size()) {
            curToken = (Token)phraseList.get(i);
            curToken.setWeight(1.0 / (double)phraseList.size());
            arrCollectionProb[i] = this.bkgCoeffi * (double)this.phraseIndexer.getIRTerm(curToken.getIndex()).getFrequency() / collectionTermCount;
            ++i;
        }
        i = 0;
        while (i < iterationNum) {
            double weightSum = 0.0;
            j = 0;
            while (j < phraseList.size()) {
                curToken = (Token)phraseList.get(j);
                arrProb[j] = (1.0 - this.bkgCoeffi) * curToken.getWeight() / ((1.0 - this.bkgCoeffi) * curToken.getWeight() + arrCollectionProb[j]) * (double)curToken.getFrequency();
                weightSum += arrProb[j];
                ++j;
            }
            j = 0;
            while (j < phraseList.size()) {
                ((Token)phraseList.get(j)).setWeight(arrProb[j] / weightSum);
                ++j;
            }
            ++i;
        }
        phraseList.setComparator(new WeightComparator(true));
        return phraseList;
    }

    private SortedArray translate(ArrayList phraseList) {
        Token curToken;
        IndexReader reader = this.searcher.getIndexReader();
        double[] arrWeight = new double[reader.getCollection().getTermNum()];
        int i = 0;
        while (i < arrWeight.length) {
            arrWeight[i] = 0.0;
            ++i;
        }
        int phraseNum = this.selfTranslation ? phraseList.size() : (100 < phraseList.size() ? 100 : phraseList.size());
        i = 0;
        while (i < phraseNum) {
            int j;
            curToken = (Token)phraseList.get(i);
            if (this.selfTranslation) {
                String curPhrase = this.phraseIndexer.getTermKey(curToken.getIndex());
                String[] arrWord = curPhrase.split(" ");
                j = 0;
                while (j < arrWord.length) {
                    IRTerm curTerm = reader.getIRTerm(arrWord[j]);
                    if (curTerm != null) {
                        int n = curTerm.getIndex();
                        arrWeight[n] = arrWeight[n] + curToken.getWeight();
                    }
                    ++j;
                }
            } else {
                int[] arrIndex = this.transMatrix.getNonZeroColumnsInRow(curToken.getIndex());
                double[] arrTransProb = this.transMatrix.getNonZeroDoubleScoresInRow(curToken.getIndex());
                if (arrIndex != null) {
                    j = 0;
                    while (j < arrIndex.length) {
                        int n = arrIndex[j];
                        arrWeight[n] = arrWeight[n] + curToken.getWeight() * arrTransProb[j];
                        ++j;
                    }
                }
            }
            ++i;
        }
        SortedArray termList = new SortedArray(new WeightComparator(true));
        i = 0;
        while (i < arrWeight.length) {
            if (arrWeight[i] > 0.0) {
                curToken = new Token(null);
                curToken.setWeight(arrWeight[i]);
                curToken.setIndex(i);
                termList.add(curToken);
            }
            ++i;
        }
        return termList;
    }
}

