/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.feedback;

import dragon.ir.index.IRTerm;
import dragon.ir.query.IRQuery;
import dragon.ir.query.Operator;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleExpression;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.Searcher;
import dragon.ir.search.feedback.Feedback;
import dragon.nlp.compare.IndexComparator;
import dragon.nlp.compare.WeightComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public abstract class AbstractFeedback
implements Feedback {
    protected int feedbackDocNum;
    protected Searcher searcher;
    protected double feedbackCoeffi;

    protected abstract ArrayList estimateNewQueryModel(IRQuery var1);

    public AbstractFeedback(Searcher searcher, int feedbackDocNum, double feedbackCoeffi) {
        this.searcher = searcher;
        this.feedbackDocNum = feedbackDocNum;
        this.feedbackCoeffi = feedbackCoeffi;
    }

    public int getFeedbackDocNum() {
        return this.feedbackDocNum;
    }

    public void setFeedbackDocNum(int docNum) {
        this.feedbackDocNum = docNum;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    public IRQuery updateQueryModel(IRQuery oldQuery) {
        SimpleTermPredicate curPredicate;
        ArrayList newTermList = this.estimateNewQueryModel(oldQuery);
        if (newTermList == null || newTermList.size() == 0) {
            return oldQuery;
        }
        int termNum = newTermList.size();
        SortedArray oldTermList = new SortedArray(new IndexComparator());
        double weightSum = 0.0;
        int i = 0;
        while (i < oldQuery.getChildNum()) {
            curPredicate = ((SimpleTermPredicate)oldQuery.getChild(i)).copy();
            if (curPredicate.getDocFrequency() > 0) {
                oldTermList.add(curPredicate);
                weightSum += curPredicate.getWeight();
            }
            ++i;
        }
        i = 0;
        while (i < oldTermList.size()) {
            curPredicate = (SimpleTermPredicate)oldTermList.get(i);
            curPredicate.setWeight(curPredicate.getWeight() / weightSum * (1.0 - this.feedbackCoeffi));
            ++i;
        }
        i = 0;
        while (i < newTermList.size()) {
            curPredicate = (SimpleTermPredicate)newTermList.get(i);
            curPredicate.setWeight(curPredicate.getWeight() * this.feedbackCoeffi);
            if (!oldTermList.add(curPredicate)) {
                SimpleTermPredicate oldPredicate = (SimpleTermPredicate)oldTermList.get(oldTermList.insertedPos());
                oldPredicate.setWeight(oldPredicate.getWeight() + curPredicate.getWeight());
            }
            ++i;
        }
        oldTermList.setComparator(new WeightComparator(true));
        weightSum = 0.0;
        i = 0;
        while (i < termNum) {
            weightSum += ((SimpleTermPredicate)oldTermList.get(i)).getWeight();
            ++i;
        }
        RelSimpleQuery query = new RelSimpleQuery();
        i = 0;
        while (i < termNum) {
            curPredicate = (SimpleTermPredicate)oldTermList.get(i);
            curPredicate.setWeight(curPredicate.getWeight() / weightSum);
            query.add(curPredicate);
            ++i;
        }
        return query;
    }

    protected IRTerm buildIRTerm(SimpleTermPredicate predicate) {
        IRTerm cur = new IRTerm(predicate.getIndex(), predicate.getFrequency(), predicate.getDocFrequency());
        cur.setKey(predicate.getKey());
        return cur;
    }

    protected SimpleTermPredicate buildSimpleTermPredicate(int termIndex, double queryWeight) {
        IRTerm curTerm = this.searcher.getIndexReader().getIRTerm(termIndex);
        SimpleTermPredicate predicate = new SimpleTermPredicate(new SimpleExpression("TERM", new Operator("="), curTerm.getKey()));
        predicate.setWeight(queryWeight);
        predicate.setFrequency(curTerm.getFrequency());
        predicate.setDocFrequency(curTerm.getDocFrequency());
        predicate.setIndex(termIndex);
        return predicate;
    }
}

