/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.expand;

import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.Operator;
import dragon.ir.query.Predicate;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleExpression;
import dragon.ir.query.SimpleTermPredicate;
import dragon.nlp.compare.IndexComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class AbstractQE {
    IndexReader indexReader;

    public AbstractQE(IndexReader indexReader) {
        this.indexReader = indexReader;
    }

    protected SimpleTermPredicate[] checkSimpleTermQuery(RelSimpleQuery query) {
        ArrayList<SimpleTermPredicate> list2 = new ArrayList<SimpleTermPredicate>();
        int i = 0;
        while (i < query.getChildNum()) {
            if (((Predicate)query.getChild(i)).isTermPredicate()) {
                IRTerm curIRTerm;
                SimpleTermPredicate predicate = (SimpleTermPredicate)query.getChild(i);
                if (predicate.getDocFrequency() <= 0 && (curIRTerm = this.indexReader.getIRTerm(predicate.getKey())) != null) {
                    predicate.setDocFrequency(curIRTerm.getDocFrequency());
                    predicate.setFrequency(curIRTerm.getFrequency());
                    predicate.setIndex(curIRTerm.getIndex());
                }
                if (predicate.getDocFrequency() > 0) {
                    list2.add(predicate);
                }
            }
            ++i;
        }
        SimpleTermPredicate[] arrPredicate = new SimpleTermPredicate[list2.size()];
        i = 0;
        while (i < list2.size()) {
            arrPredicate[i] = ((SimpleTermPredicate)list2.get(i)).copy();
            ++i;
        }
        return arrPredicate;
    }

    protected SimpleTermPredicate buildSimpleTermPredicate(int termIndex, double queryWeight) {
        IRTerm curTerm = this.indexReader.getIRTerm(termIndex);
        SimpleTermPredicate predicate = new SimpleTermPredicate(new SimpleExpression("TERM", new Operator("="), curTerm.getKey()));
        predicate.setWeight(queryWeight);
        predicate.setFrequency(curTerm.getFrequency());
        predicate.setDocFrequency(curTerm.getDocFrequency());
        predicate.setIndex(termIndex);
        return predicate;
    }

    protected IRQuery buildQuery(SimpleTermPredicate[] oldQuery, SimpleTermPredicate[] newQuery, double expandCoeffi) {
        RelSimpleQuery query = new RelSimpleQuery();
        SortedArray list2 = new SortedArray(new IndexComparator());
        this.normalizeQuery(oldQuery);
        this.normalizeQuery(newQuery);
        int i = 0;
        while (i < oldQuery.length) {
            oldQuery[i].setWeight(oldQuery[i].getWeight() * (1.0 - expandCoeffi));
            list2.add(oldQuery[i]);
            ++i;
        }
        i = 0;
        while (i < newQuery.length) {
            newQuery[i].setWeight(newQuery[i].getWeight() * expandCoeffi);
            if (!list2.add(newQuery[i])) {
                double weight = ((SimpleTermPredicate)list2.get(list2.insertedPos())).getWeight();
                ((SimpleTermPredicate)list2.get(list2.insertedPos())).setWeight(weight + newQuery[i].getWeight());
            }
            ++i;
        }
        i = 0;
        while (i < list2.size()) {
            query.add((SimpleTermPredicate)list2.get(i));
            ++i;
        }
        return query;
    }

    private void normalizeQuery(SimpleTermPredicate[] query) {
        double sum2 = 0.0;
        int i = 0;
        while (i < query.length) {
            sum2 += query[i].getWeight();
            ++i;
        }
        i = 0;
        while (i < query.length) {
            query[i].setWeight(query[i].getWeight() / sum2);
            ++i;
        }
    }
}

