/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search.evaluate;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.nlp.compare.IndexComparator;
import dragon.util.FileUtil;
import dragon.util.FormatUtil;
import dragon.util.SortedArray;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;

public class TrecEva {
    private String evaResultFolder;
    private double[] evaResult;

    public TrecEva(String evaResultFolder) {
        this.evaResultFolder = evaResultFolder;
    }

    public double[] evaluateQuery(IRQuery query, ArrayList hitlist, ArrayList relevantList) {
        return this.evaluateQuery(query, hitlist, relevantList, null);
    }

    public double[] evaluateQuery(IRQuery query, ArrayList hitlist, ArrayList relevantList, IndexReader indexReader) {
        try {
            double top100Precision = 0.0;
            double top100Recall = 0.0;
            double top10Precision = 0.0;
            double top10Recall = 0.0;
            double avgPrecision = 0.0;
            double overallPrecision = 0.0;
            double overallRecall = 0.0;
            double[] result2 = new double[10];
            if (relevantList == null || relevantList.size() == 0 || hitlist == null || hitlist.size() == 0) {
                return result2;
            }
            DecimalFormat df = FormatUtil.getNumericFormat(2, 2);
            DecimalFormat dfWeight = FormatUtil.getNumericFormat(2, 4);
            int topicID = query.getQueryKey();
            PrintWriter out1 = FileUtil.getPrintWriter(this.evaResultFolder + "/topic_" + topicID + ".eva");
            int base = relevantList.size();
            int retrieved = hitlist.size();
            if (retrieved > 1000) {
                retrieved = 1000;
            }
            int relevant = 0;
            IndexComparator indexComparator = new IndexComparator();
            Collections.sort(relevantList, indexComparator);
            out1.write(query.toString() + "\n");
            out1.flush();
            int i = 0;
            while (i < retrieved) {
                IRDoc curDoc = (IRDoc)hitlist.get(i);
                if (SortedArray.binarySearch(relevantList, curDoc, indexComparator) >= 0) {
                    avgPrecision += 100.0 * (double)(++relevant) / (double)(i + 1);
                }
                if (i == 9) {
                    top10Precision = 100.0 * (double)relevant / (double)(i + 1);
                    top10Recall = 100.0 * (double)relevant / (double)base;
                }
                if (i == 99) {
                    top100Precision = 100.0 * (double)relevant / (double)(i + 1);
                    top100Recall = 100.0 * (double)relevant / (double)base;
                }
                if (indexReader == null) {
                    out1.write("Top " + (i + 1) + " #" + curDoc.getIndex() + "(" + relevant + "): ");
                } else {
                    out1.write("Top " + (i + 1) + " #" + indexReader.getDocKey(curDoc.getIndex()) + "(#" + curDoc.getIndex() + ", " + relevant + "): ");
                }
                out1.write(dfWeight.format(curDoc.getWeight()) + " " + df.format(100.0 * (double)relevant / (double)(i + 1)) + "%/" + df.format(100.0 * (double)relevant / (double)base) + "%\r\n");
                out1.flush();
                ++i;
            }
            overallPrecision = 100.0 * (double)relevant / (double)retrieved;
            overallRecall = 100.0 * (double)relevant / (double)base;
            if (retrieved < 10) {
                top10Precision = overallPrecision;
                top10Recall = overallRecall;
            }
            if (retrieved < 100) {
                top100Precision = overallPrecision;
                top100Recall = overallRecall;
            }
            out1.write("Top 10 Precison/Recall:" + df.format(top10Precision) + "%/" + df.format(top10Recall) + "%\r\n");
            out1.write("Top 100 Precison/Recall:" + df.format(top100Precision) + "%/" + df.format(top100Recall) + "%\r\n");
            out1.write("Overall Precison/Recall:" + df.format(overallPrecision) + "%/" + df.format(overallRecall) + "%\r\n");
            out1.write("Average Precison:" + df.format(avgPrecision /= (double)base) + "%\r\n");
            out1.close();
            result2[0] = topicID;
            result2[1] = retrieved;
            result2[2] = relevant;
            result2[3] = top10Precision;
            result2[4] = top10Recall;
            result2[5] = top100Precision;
            result2[6] = top100Recall;
            result2[7] = overallPrecision;
            result2[8] = overallRecall;
            result2[9] = avgPrecision;
            this.evaResult = new double[10];
            System.arraycopy(result2, 0, this.evaResult, 0, 10);
            return result2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getTopicID() {
        return (int)this.evaResult[0];
    }

    public int getRetrievedDocNum() {
        return (int)this.evaResult[1];
    }

    public int getRelevantDocNum() {
        return (int)this.evaResult[2];
    }

    public double getTop10Precision() {
        return this.evaResult[3];
    }

    public double getTop10Recall() {
        return this.evaResult[4];
    }

    public double getTop100Precision() {
        return this.evaResult[5];
    }

    public double getTop100Recall() {
        return this.evaResult[6];
    }

    public double getOverallPrecision() {
        return this.evaResult[7];
    }

    public double getOverallRecall() {
        return this.evaResult[8];
    }

    public double getAveragePrecision() {
        return this.evaResult[9];
    }
}

