/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.AbstractSearcher;
import dragon.ir.search.smooth.Smoother;
import dragon.nlp.compare.WeightComparator;
import java.util.ArrayList;
import java.util.Collections;

public class BoolRankSearcher
extends AbstractSearcher {
    public BoolRankSearcher(IndexReader indexReader, Smoother smoother) {
        super(indexReader, smoother);
    }

    public int search(IRQuery query) {
        if (!query.isRelBoolQuery()) {
            this.hitlist = null;
            return 0;
        }
        this.query = query;
        this.hitlist = this.getHitList(query);
        Collections.sort(this.hitlist, new WeightComparator(true));
        return this.hitlist.size();
    }

    private ArrayList getHitList(IRQuery query) {
        ArrayList list2;
        if (query.isPredicate()) {
            list2 = this.checkSimpleTermPredicate(query) ? this.getDocList((SimpleTermPredicate)query) : null;
        } else {
            list2 = this.getHitList(query.getChild(0));
            int i = 1;
            while (i < query.getChildNum()) {
                list2 = query.getOperator().toString().equalsIgnoreCase("AND") ? this.addDocList(list2, this.getHitList(query.getChild(i)), true) : this.addDocList(list2, this.getHitList(query.getChild(i)), false);
                ++i;
            }
        }
        return list2;
    }

    private ArrayList getDocList(SimpleTermPredicate predicate) {
        try {
            IRDoc[] arrDoc = this.indexReader.getTermDocList(predicate.getIndex());
            ArrayList<IRDoc> list2 = new ArrayList<IRDoc>(arrDoc.length);
            int[] arrFreq = this.indexReader.getTermDocFrequencyList(predicate.getIndex());
            this.smoother.setQueryTerm(predicate);
            int i = 0;
            while (i < arrDoc.length) {
                arrDoc[i].setWeight(this.smoother.getSmoothedProb(arrDoc[i], arrFreq[i]));
                list2.add(arrDoc[i]);
                ++i;
            }
            return list2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ArrayList addDocList(ArrayList hisDocList, ArrayList curDocList, boolean interaction) {
        int k;
        int i = 0;
        int j = 0;
        ArrayList<IRDoc> newList = new ArrayList<IRDoc>();
        while (i < hisDocList.size() && j < curDocList.size()) {
            IRDoc hisDoc = (IRDoc)hisDocList.get(i);
            IRDoc curDoc = (IRDoc)curDocList.get(j);
            if (hisDoc.getIndex() == curDoc.getIndex()) {
                hisDoc.setWeight(hisDoc.getWeight() + curDoc.getWeight());
                newList.add(hisDoc);
                ++i;
                ++j;
                continue;
            }
            if (hisDoc.getIndex() < curDoc.getIndex()) {
                if (!interaction) {
                    newList.add(hisDoc);
                }
                ++i;
                continue;
            }
            if (!interaction) {
                newList.add(curDoc);
            }
            ++j;
        }
        if (j < curDocList.size() && !interaction) {
            k = j;
            while (k < curDocList.size()) {
                newList.add((IRDoc)curDocList.get(k));
                ++k;
            }
        }
        if (i < hisDocList.size() && !interaction) {
            k = i;
            while (k < hisDocList.size()) {
                newList.add((IRDoc)hisDocList.get(k));
                ++k;
            }
        }
        return newList;
    }

    private boolean checkSimpleTermPredicate(IRQuery query) {
        IRTerm curIRTerm;
        SimpleTermPredicate predicate = (SimpleTermPredicate)query;
        if (predicate.getDocFrequency() <= 0 && (curIRTerm = this.indexReader.getIRTerm(predicate.getKey())) != null) {
            predicate.setDocFrequency(curIRTerm.getDocFrequency());
            predicate.setFrequency(curIRTerm.getFrequency());
            predicate.setIndex(curIRTerm.getIndex());
        }
        return predicate.getDocFrequency() > 0;
    }
}

