/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.search;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.query.IRQuery;
import dragon.ir.query.Predicate;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.query.SimpleTermPredicate;
import dragon.ir.search.Searcher;
import dragon.ir.search.smooth.Smoother;
import java.util.ArrayList;

public abstract class AbstractSearcher
implements Searcher {
    protected IndexReader indexReader;
    protected ArrayList hitlist;
    protected IRQuery query;
    protected Smoother smoother;
    private boolean queryWeighting;

    public AbstractSearcher(IndexReader indexReader, Smoother smoother) {
        this.indexReader = indexReader;
        this.smoother = smoother;
        this.queryWeighting = true;
    }

    protected SimpleTermPredicate[] checkSimpleTermQuery(RelSimpleQuery query) {
        ArrayList<SimpleTermPredicate> list2 = new ArrayList<SimpleTermPredicate>();
        int i = 0;
        while (i < query.getChildNum()) {
            if (((Predicate)query.getChild(i)).isTermPredicate()) {
                IRTerm curIRTerm;
                SimpleTermPredicate predicate = (SimpleTermPredicate)query.getChild(i);
                if (predicate.getDocFrequency() <= 0 && (curIRTerm = this.indexReader.getIRTerm(predicate.getKey())) != null) {
                    predicate.setDocFrequency(curIRTerm.getDocFrequency());
                    predicate.setFrequency(curIRTerm.getFrequency());
                    predicate.setIndex(curIRTerm.getIndex());
                }
                if (predicate.getDocFrequency() > 0) {
                    list2.add(predicate);
                }
            }
            ++i;
        }
        SimpleTermPredicate[] arrPredicate = new SimpleTermPredicate[list2.size()];
        i = 0;
        while (i < list2.size()) {
            arrPredicate[i] = ((SimpleTermPredicate)list2.get(i)).copy();
            if (!this.queryWeighting) {
                arrPredicate[i].setWeight(1.0);
            }
            ++i;
        }
        return arrPredicate;
    }

    public IRDoc getIRDoc(int ranking) {
        return (IRDoc)this.hitlist.get(ranking);
    }

    public ArrayList getRankedDocumentList() {
        return this.hitlist;
    }

    public int getRetrievedDocNum() {
        return this.hitlist.size();
    }

    public Smoother getSmoother() {
        return this.smoother;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public IRQuery getQuery() {
        return this.query;
    }

    public void setQueryWeightingOption(boolean option) {
        this.queryWeighting = option;
    }

    public boolean getQueryWeightingOption() {
        return this.queryWeighting;
    }
}

