/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.query;

import dragon.ir.index.IRSection;
import dragon.ir.query.AbstractQueryGenerator;
import dragon.ir.query.IRQuery;
import dragon.ir.query.QueryWriter;
import dragon.ir.query.RelSimpleQuery;
import dragon.nlp.extract.ConceptExtractor;
import dragon.nlp.extract.TripleExtractor;
import dragon.onlinedb.Article;
import java.util.ArrayList;
import java.util.Collections;

public class BasicQueryGenerator
extends AbstractQueryGenerator {
    protected QueryWriter writer;
    protected IRSection[] arrSections;
    protected boolean relationSupported;
    protected boolean initialized;
    private ArrayList sectionConceptList;
    private ArrayList sectionRelationList;
    private TripleExtractor te;
    private ConceptExtractor ce;

    public BasicQueryGenerator(TripleExtractor te, boolean indexConceptEntry) {
        this.te = te;
        this.relationSupported = true;
        this.writer = new QueryWriter(this.relationSupported, indexConceptEntry);
        this.initialized = false;
        this.sectionConceptList = new ArrayList();
        this.sectionRelationList = new ArrayList();
    }

    public BasicQueryGenerator(ConceptExtractor ce, boolean indexConceptEntry) {
        this.ce = ce;
        this.relationSupported = false;
        this.writer = new QueryWriter(this.relationSupported, indexConceptEntry);
        this.initialized = false;
        this.sectionConceptList = new ArrayList();
        this.sectionRelationList = new ArrayList();
    }

    public void initialize(double titleWeight, double abstractWeight, double bodyWeight, double metaWeight, double subtermWeight) {
        IRSection cur;
        ArrayList<IRSection> sectionList = new ArrayList<IRSection>();
        this.writer.setSubTermWeight(subtermWeight);
        if (titleWeight > 0.0) {
            cur = new IRSection(1);
            cur.setWeight(titleWeight);
            sectionList.add(cur);
        }
        if (abstractWeight > 0.0) {
            cur = new IRSection(2);
            cur.setWeight(abstractWeight);
            sectionList.add(cur);
        }
        if (bodyWeight > 0.0) {
            cur = new IRSection(3);
            cur.setWeight(bodyWeight);
            sectionList.add(cur);
        }
        if (metaWeight > 0.0) {
            cur = new IRSection(4);
            cur.setWeight(metaWeight);
            sectionList.add(cur);
        }
        this.arrSections = new IRSection[sectionList.size()];
        Collections.sort(sectionList);
        int i = 0;
        while (i < sectionList.size()) {
            this.arrSections[i] = cur = (IRSection)sectionList.get(i);
            this.writer.addSection(cur.copy());
            ++i;
        }
        this.initialized = true;
    }

    public IRQuery generate(Article article) {
        try {
            if (!this.initialized) {
                return null;
            }
            this.writer.initNewQuery();
            int i = 0;
            while (i < this.arrSections.length) {
                this.sectionConceptList.clear();
                this.sectionRelationList.clear();
                int sectionID = this.arrSections[i].getSectionID();
                if (this.relationSupported) {
                    this.extract(this.getSection(article, sectionID), this.sectionConceptList, this.sectionRelationList);
                    this.writer.write(sectionID, this.sectionConceptList, this.sectionRelationList);
                } else {
                    this.extract(this.getSection(article, sectionID), this.sectionConceptList);
                    this.writer.write(sectionID, this.sectionConceptList);
                }
                ++i;
            }
            return new RelSimpleQuery(this.writer.getQuery());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean extract(String content, ArrayList conceptList, ArrayList relationList) {
        if (content == null || content.length() <= 5) {
            return true;
        }
        boolean ret = this.te.extractFromDoc(content);
        if (ret) {
            if (this.te.getConceptList() != null) {
                conceptList.addAll(this.te.getConceptList());
            }
            if (this.te.getTripleList() != null) {
                relationList.addAll(this.te.getTripleList());
            }
        }
        return ret;
    }

    private boolean extract(String content, ArrayList conceptList) {
        if (content == null || content.length() <= 2) {
            return true;
        }
        if (this.ce.extractFromDoc(content) != null) {
            conceptList.addAll(this.ce.getConceptList());
            return true;
        }
        return false;
    }

    private String getSection(Article paper, int sectionID) {
        switch (sectionID) {
            case 1: {
                return paper.getTitle();
            }
            case 2: {
                return paper.getAbstract();
            }
            case 3: {
                return paper.getBody();
            }
            case 4: {
                return paper.getMeta();
            }
        }
        return null;
    }
}

